/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient.build;

import io.cloudslang.content.httpclient.build.Utils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class URIBuilder {
    private String url;
    private String queryParams;
    private String queryParamsAreURLEncoded = "false";
    private String queryParamsAreFormEncoded = "true";

    public URIBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public URIBuilder setQueryParams(String queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public URIBuilder setQueryParamsAreURLEncoded(String queryParamsAreURLEncoded) {
        if (!StringUtils.isBlank((CharSequence)queryParamsAreURLEncoded)) {
            this.queryParamsAreURLEncoded = queryParamsAreURLEncoded;
        }
        return this;
    }

    public URIBuilder setQueryParamsAreFormEncoded(String queryParamsAreFormEncoded) {
        if (!StringUtils.isBlank((CharSequence)queryParamsAreFormEncoded)) {
            this.queryParamsAreFormEncoded = queryParamsAreFormEncoded;
        }
        return this;
    }

    public URI buildURI() {
        org.apache.http.client.utils.URIBuilder uriBuilder;
        try {
            new URL(this.url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("the value '" + this.url + "' is not a valid URL", e);
        }
        try {
            uriBuilder = new org.apache.http.client.utils.URIBuilder(this.url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("the value '" + this.url + "' is not a valid URI", e);
        }
        boolean bEncodeQueryParams = !Boolean.parseBoolean(this.queryParamsAreURLEncoded);
        boolean bEncodeQueryParamsAsForm = Boolean.parseBoolean(this.queryParamsAreFormEncoded);
        if (!StringUtils.isEmpty((CharSequence)this.queryParams)) {
            try {
                if (bEncodeQueryParamsAsForm) {
                    uriBuilder.addParameters(Utils.urlEncodeMultipleParams(this.queryParams, bEncodeQueryParams));
                } else {
                    uriBuilder.setCustomQuery(Utils.urlEncodeQueryParams(this.queryParams, bEncodeQueryParams));
                }
            }
            catch (IllegalArgumentException ie) {
                throw new IllegalArgumentException("queryParamsAreURLEncoded is 'false' but queryParams are not properly encoded. " + ie.getMessage(), ie);
            }
        }
        try {
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("could not build 'url' for " + this.url + " and queries " + this.queryParamsAreURLEncoded, e);
        }
    }
}

