/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient.build;

import io.cloudslang.content.httpclient.build.UrlEncodeException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class Utils {
    public static final String DEFAULT_CHARACTER_SET = "UTF-8";

    public static List<? extends NameValuePair> urlEncodeMultipleParams(String params, boolean urlEncode) throws UrlEncodeException {
        String[] pairs;
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (String pair : pairs = params.split("&")) {
            String value;
            String[] nameValue = pair.split("=", 2);
            String name = nameValue[0];
            String string = value = nameValue.length == 2 ? nameValue[1] : null;
            if (!urlEncode) {
                try {
                    name = URLDecoder.decode(name, DEFAULT_CHARACTER_SET);
                    if (value != null) {
                        value = URLDecoder.decode(value, DEFAULT_CHARACTER_SET);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException ie) {
                    throw new UrlEncodeException(ie.getMessage(), ie);
                }
            }
            list.add(new BasicNameValuePair(name, value));
        }
        return list;
    }

    public static String urlEncodeQueryParams(String params, boolean urlEncode) throws UrlEncodeException {
        String encodedParams = params;
        if (!urlEncode) {
            try {
                encodedParams = URLDecoder.decode(params, DEFAULT_CHARACTER_SET);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException ie) {
                throw new UrlEncodeException(ie.getMessage(), ie);
            }
        }
        return encodedParams;
    }

    public static int validatePortNumber(String portStringValue) {
        int portNumber;
        StringBuilder exceptionMessageBuilder = new StringBuilder();
        exceptionMessageBuilder.append("Invalid value '").append(portStringValue).append("' for input '").append("proxyPort").append("'. Valid Values: -1 and integer values greater than 0. ");
        try {
            portNumber = Integer.parseInt(portStringValue);
            if (portNumber < 0 && portNumber != -1) {
                throw new IllegalArgumentException(exceptionMessageBuilder.toString());
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(exceptionMessageBuilder.toString(), e);
        }
        return portNumber;
    }
}

