/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient.build.auth;

import io.cloudslang.content.httpclient.build.auth.AuthTypes;
import io.cloudslang.content.httpclient.build.auth.JCIFSEngine;
import io.cloudslang.content.httpclient.build.auth.KrbHttpLoginModule;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.NTLMEngine;
import org.apache.http.impl.auth.NTLMScheme;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

public class AuthSchemeProviderLookupBuilder {
    private AuthTypes authTypes;
    private String skipPortAtKerberosDatabaseLookup = "true";
    private String kerberosConfigFile;
    private String kerberosLoginConfigFile;
    private String host;
    private String username;
    private String password;
    private List<Header> headers;

    public AuthSchemeProviderLookupBuilder setAuthTypes(AuthTypes authTypes) {
        this.authTypes = authTypes;
        return this;
    }

    public AuthSchemeProviderLookupBuilder setSkipPortAtKerberosDatabaseLookup(String skipPortAtKerberosDatabaseLookup) {
        if (!StringUtils.isEmpty((CharSequence)skipPortAtKerberosDatabaseLookup)) {
            this.skipPortAtKerberosDatabaseLookup = skipPortAtKerberosDatabaseLookup;
        }
        return this;
    }

    public AuthSchemeProviderLookupBuilder setKerberosConfigFile(String kerberosConfigFile) {
        this.kerberosConfigFile = kerberosConfigFile;
        return this;
    }

    public AuthSchemeProviderLookupBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    public AuthSchemeProviderLookupBuilder setKerberosLoginConfigFile(String kerberosLoginConfigFile) {
        this.kerberosLoginConfigFile = kerberosLoginConfigFile;
        return this;
    }

    public AuthSchemeProviderLookupBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public AuthSchemeProviderLookupBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    public AuthSchemeProviderLookupBuilder setHeaders(List<Header> headers) {
        this.headers = headers;
        return this;
    }

    public Lookup<AuthSchemeProvider> buildAuthSchemeProviderLookup() {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        block18: for (String type : this.authTypes) {
            switch (type.trim()) {
                case "NTLM": {
                    registryBuilder.register("NTLM", (Object)new AuthSchemeProvider(){

                        public AuthScheme create(HttpContext httpContext) {
                            return new NTLMScheme((NTLMEngine)new JCIFSEngine());
                        }
                    });
                    continue block18;
                }
                case "BASIC": {
                    registryBuilder.register("Basic", (Object)new BasicSchemeFactory(Charset.forName("UTF-8")));
                    String value = this.username + ":" + this.password;
                    byte[] encodedValue = Base64.encodeBase64((byte[])value.getBytes(StandardCharsets.UTF_8));
                    this.headers.add((Header)new BasicHeader("Authorization", "Basic " + new String(encodedValue)));
                    continue block18;
                }
                case "DIGEST": {
                    registryBuilder.register("Digest", (Object)new DigestSchemeFactory());
                    continue block18;
                }
                case "KERBEROS": {
                    if (this.kerberosConfigFile != null) {
                        System.setProperty("java.security.krb5.conf", this.kerberosConfigFile);
                    } else {
                        File krb5Config;
                        String domain = this.host.replaceAll(".*\\.(?=.*\\.)", "");
                        try {
                            krb5Config = AuthSchemeProviderLookupBuilder.createKrb5Configuration(domain);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("could not create the krb5 config file" + e.getMessage(), e);
                        }
                        System.setProperty("java.security.krb5.conf", krb5Config.toURI().toString());
                    }
                    if (this.kerberosLoginConfigFile != null) {
                        System.setProperty("java.security.auth.login.config", this.kerberosLoginConfigFile);
                    } else {
                        File loginConfig;
                        try {
                            loginConfig = AuthSchemeProviderLookupBuilder.createLoginConfig();
                        }
                        catch (IOException e) {
                            throw new RuntimeException("could not create the kerberos login config file" + e.getMessage(), e);
                        }
                        System.setProperty("java.security.auth.login.config", loginConfig.toURI().toString());
                    }
                    if (this.password != null) {
                        System.setProperty(KrbHttpLoginModule.PAS, this.password);
                    }
                    if (this.username != null) {
                        System.setProperty(KrbHttpLoginModule.USR, this.username);
                    }
                    System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                    boolean skipPort = Boolean.parseBoolean(this.skipPortAtKerberosDatabaseLookup);
                    registryBuilder.register("Kerberos", (Object)new KerberosSchemeFactory(skipPort));
                    registryBuilder.register("negotiate", (Object)new SPNegoSchemeFactory(skipPort));
                    continue block18;
                }
                case "ANONYMOUS": {
                    continue block18;
                }
            }
            throw new IllegalStateException("Unsupported 'authType'authentication scheme: " + type);
        }
        return registryBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createKrb5Configuration(String domain) throws IOException {
        File tempFile = File.createTempFile("krb", "kdc");
        tempFile.deleteOnExit();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("[libdefaults]");
        lines.add("\tdefault_realm = " + domain.toUpperCase());
        lines.add("[realms]");
        lines.add("\t" + domain.toUpperCase() + " = {");
        lines.add("\t\tkdc = " + domain);
        lines.add("\t\tadmin_server = " + domain);
        lines.add("\t}");
        FileWriter writer = null;
        try {
            writer = new FileWriter(tempFile);
            IOUtils.writeLines(lines, (String)System.lineSeparator(), (Writer)writer);
        }
        finally {
            if (writer != null) {
                AuthSchemeProviderLookupBuilder.safeClose(writer);
            }
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createLoginConfig() throws IOException {
        File tempFile = File.createTempFile("krb", "loginConf");
        tempFile.deleteOnExit();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("com.sun.security.jgss.initiate {\n  " + KrbHttpLoginModule.class.getCanonicalName() + " required\n" + "  doNotPrompt=true\n" + "  useFirstPass=true\n" + "  debug=true ;\n" + "};");
        FileWriter writer = null;
        try {
            writer = new FileWriter(tempFile);
            IOUtils.writeLines(lines, (String)System.lineSeparator(), (Writer)writer);
        }
        finally {
            if (writer != null) {
                AuthSchemeProviderLookupBuilder.safeClose(writer);
            }
        }
        return tempFile;
    }

    public static void safeClose(FileWriter fis) {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }
}

