/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient.build.auth;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AuthTypes
implements Iterable<String> {
    public static final String BASIC = "Basic".toUpperCase();
    public static final String DIGEST = "Digest".toUpperCase();
    public static final String NTLM = "NTLM".toUpperCase();
    public static final String KERBEROS = "Kerberos".toUpperCase();
    public static final String DEFAULT = BASIC;
    public static final String ANY = "ANY";
    public static final String ANONYMOUS = "ANONYMOUS";
    private static Set<String> supportedAuthTypes = new HashSet<String>();
    private Set<String> authTypes = new HashSet<String>();

    public AuthTypes(String authType) {
        this.parseAuthTypes(authType);
    }

    @Override
    public Iterator<String> iterator() {
        return this.authTypes.iterator();
    }

    public void add(String authType) {
        this.authTypes.add(authType.toUpperCase());
    }

    public boolean contains(String authType) {
        return this.authTypes.contains(authType.toUpperCase());
    }

    public int size() {
        return this.authTypes.size();
    }

    public void parseAuthTypes(String authType) {
        if (StringUtils.isEmpty((CharSequence)authType)) {
            this.add(DEFAULT);
            return;
        }
        if (authType.equalsIgnoreCase(ANY)) {
            this.authTypes.addAll(supportedAuthTypes);
        } else {
            String[] toks;
            for (String tok : toks = authType.split(",")) {
                if (!supportedAuthTypes.contains(tok.toUpperCase())) {
                    throw new IllegalArgumentException("unsupported authType in \"" + authType + "\"");
                }
                this.add(tok);
            }
        }
    }

    static {
        supportedAuthTypes.add(BASIC);
        supportedAuthTypes.add(DIGEST);
        supportedAuthTypes.add(NTLM);
        supportedAuthTypes.add(KERBEROS);
        supportedAuthTypes.add(ANONYMOUS);
    }
}

