/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient.build.auth;

import io.cloudslang.content.httpclient.build.Utils;
import io.cloudslang.content.httpclient.build.auth.AuthTypes;
import java.security.Principal;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;

public class CredentialsProviderBuilder {
    private AuthTypes authTypes;
    private String username;
    private String password;
    private String host;
    private String port;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;

    public CredentialsProviderBuilder setAuthTypes(AuthTypes authTypes) {
        this.authTypes = authTypes;
        return this;
    }

    public CredentialsProviderBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public CredentialsProviderBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    public CredentialsProviderBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    public CredentialsProviderBuilder setPort(String port) {
        this.port = port;
        return this;
    }

    public CredentialsProviderBuilder setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public CredentialsProviderBuilder setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public CredentialsProviderBuilder setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
        return this;
    }

    public CredentialsProviderBuilder setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    public CredentialsProvider buildCredentialsProvider() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (!StringUtils.isEmpty((CharSequence)this.username)) {
            UsernamePasswordCredentials credentials;
            if (this.authTypes.contains(AuthTypes.NTLM)) {
                String[] domainAndUsername = CredentialsProviderBuilder.getDomainUsername(this.username);
                credentials = new NTCredentials(domainAndUsername[1], this.password, this.host, domainAndUsername[0]);
            } else {
                credentials = new UsernamePasswordCredentials(this.username, this.password);
            }
            credentialsProvider.setCredentials(new AuthScope(this.host, Integer.parseInt(this.port)), (Credentials)credentials);
        } else if (this.authTypes.contains(AuthTypes.KERBEROS)) {
            credentialsProvider.setCredentials(new AuthScope(this.host, Integer.parseInt(this.port)), new Credentials(){

                public Principal getUserPrincipal() {
                    return null;
                }

                public String getPassword() {
                    return null;
                }
            });
        }
        if (!StringUtils.isEmpty((CharSequence)this.proxyUsername)) {
            int intProxyPort = 8080;
            if (!StringUtils.isEmpty((CharSequence)this.proxyPort)) {
                intProxyPort = Utils.validatePortNumber(this.proxyPort);
            }
            credentialsProvider.setCredentials(new AuthScope(this.proxyHost, intProxyPort), (Credentials)new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword));
        }
        return credentialsProvider;
    }

    private static String[] getDomainUsername(String username) {
        int atBackSlash = username.indexOf(92);
        String usernameWithoutDomain = username.substring(atBackSlash + 1);
        String domain = ".";
        if (atBackSlash >= 0) {
            domain = username.substring(0, atBackSlash).toUpperCase(Locale.ENGLISH);
        }
        return new String[]{domain, usernameWithoutDomain};
    }
}

