/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient.build.conn;

import com.hp.oo.sdk.content.plugin.GlobalSessionObject;
import com.hp.oo.sdk.content.plugin.SessionResource;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ConnectionManagerBuilder {
    private GlobalSessionObject<Map<String, PoolingHttpClientConnectionManager>> connectionPoolHolder;
    private SSLConnectionSocketFactory sslsf;
    private String connectionManagerMapKey;
    private String defaultMaxPerRoute;
    private String totalMax;

    public ConnectionManagerBuilder setConnectionPoolHolder(GlobalSessionObject connectionPoolHolder) {
        this.connectionPoolHolder = connectionPoolHolder;
        return this;
    }

    public ConnectionManagerBuilder setSslsf(SSLConnectionSocketFactory sslsf) {
        this.sslsf = sslsf;
        return this;
    }

    public ConnectionManagerBuilder setTotalMax(String totalMax) {
        this.totalMax = totalMax;
        return this;
    }

    public ConnectionManagerBuilder setDefaultMaxPerRoute(String defaultMaxPerRoute) {
        this.defaultMaxPerRoute = defaultMaxPerRoute;
        return this;
    }

    public ConnectionManagerBuilder setConnectionManagerMapKey(String ... connectionManagerMapKeys) {
        this.connectionManagerMapKey = ConnectionManagerBuilder.buildConnectionManagerMapKey(connectionManagerMapKeys);
        return this;
    }

    public static String buildConnectionManagerMapKey(String ... connectionManagerMapKeys) {
        StringBuilder keyBuilder = new StringBuilder();
        for (String token : connectionManagerMapKeys) {
            keyBuilder.append(token).append(":");
        }
        if (keyBuilder.length() > 0) {
            keyBuilder.deleteCharAt(keyBuilder.length() - 1);
        }
        return keyBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolingHttpClientConnectionManager buildConnectionManager() {
        if (this.connectionPoolHolder != null) {
            PoolingHttpClientConnectionManager connManager = null;
            GlobalSessionObject<Map<String, PoolingHttpClientConnectionManager>> globalSessionObject = this.connectionPoolHolder;
            synchronized (globalSessionObject) {
                Map connectionManagerMap = (Map)this.connectionPoolHolder.get();
                if (connectionManagerMap == null) {
                    final HashMap connectionManagerMapFinal = new HashMap();
                    this.connectionPoolHolder.setResource((SessionResource)new SessionResource<Map<String, PoolingHttpClientConnectionManager>>(){

                        public Map<String, PoolingHttpClientConnectionManager> get() {
                            return connectionManagerMapFinal;
                        }

                        public void release() {
                        }
                    });
                    connectionManagerMap = (Map)this.connectionPoolHolder.get();
                }
                if ((connManager = (PoolingHttpClientConnectionManager)connectionManagerMap.get(this.connectionManagerMapKey)) == null) {
                    Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)this.sslsf).build();
                    connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
                    connectionManagerMap.put(this.connectionManagerMapKey, connManager);
                }
            }
            if (!StringUtils.isEmpty((CharSequence)this.defaultMaxPerRoute)) {
                try {
                    connManager.setDefaultMaxPerRoute(Integer.parseInt(this.defaultMaxPerRoute));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("the 'connectionsMaxPerRoute' input should be integer" + e.getMessage(), e);
                }
            }
            if (!StringUtils.isEmpty((CharSequence)this.totalMax)) {
                try {
                    connManager.setMaxTotal(Integer.parseInt(this.totalMax));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("the 'connectionsMaxTotal' input should be integer" + e.getMessage(), e);
                }
            }
            return connManager;
        }
        return null;
    }
}

