/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient.build.conn;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class SSLConnectionSocketFactoryBuilder {
    public static final String TRUST_ALL_ROOTS_ERROR = "Could not use trustAllRoots=";
    public static final String SSL_CONNECTION_ERROR = "Could not create SSL connection. Invalid keystore or trustKeystore certificates.";
    public static final String BAD_KEYSTORE_ERROR = "The keystore provided in the 'keystore' input is corrupted OR the password (in the 'keystorePassword' input) is incorrect";
    public static final String INVALID_KEYSTORE_ERROR = "A keystore could not be found or it does not contain the needed certificate";
    public static final String BAD_TRUST_KEYSTORE_ERROR = "The trust keystore provided in the 'trustKeystore' input is corrupted OR the password (in the 'trustPassword' input) is incorrect";
    public static final String INVALID_TRUST_KEYSTORE_ERROR = "A trust keystore could not be found or it does not contain the needed certificate";
    public static final String SSLv3 = "SSLv3";
    public static final String TLSv10 = "TLSv1";
    public static final String TLSv11 = "TLSv1.1";
    public static final String TLSv12 = "TLSv1.2";
    public static final String[] SUPPORTED_PROTOCOLS = new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"};
    private String trustAllRootsStr = "false";
    private String keystore;
    private String keystorePassword;
    private String trustKeystore;
    private String trustPassword;
    private String x509HostnameVerifierInputValue = "strict";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore createKeyStore(URL url, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("Keystore url may not be null");
        }
        KeyStore keystore = KeyStore.getInstance("jks");
        try (InputStream is = null;){
            is = url.openStream();
            keystore.load(is, password != null ? password.toCharArray() : null);
        }
        return keystore;
    }

    public SSLConnectionSocketFactory build() {
        SSLConnectionSocketFactory sslsf;
        if (!"true".equalsIgnoreCase(this.trustAllRootsStr) && !"false".equalsIgnoreCase(this.trustAllRootsStr)) {
            throw new IllegalArgumentException("'trustAllRoots' can only be 'true' or 'false'");
        }
        boolean trustAllRoots = Boolean.parseBoolean(this.trustAllRootsStr);
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        if (!trustAllRoots) {
            boolean useClientCert = !StringUtils.isEmpty((CharSequence)this.keystore);
            boolean useTrustCert = !StringUtils.isEmpty((CharSequence)this.trustKeystore);
            String javaKeystore = System.getProperty("java.home") + "/lib/security/cacerts";
            boolean storeExists = new File(javaKeystore).exists();
            if (!useClientCert && storeExists) {
                this.keystore = "file:" + javaKeystore;
                this.keystorePassword = StringUtils.isEmpty((CharSequence)this.keystorePassword) ? "changeit" : this.keystorePassword;
                useClientCert = true;
            } else if (useClientCert && !this.keystore.startsWith("http")) {
                this.keystore = "file:" + this.keystore;
            }
            if (!useTrustCert && storeExists) {
                this.trustKeystore = "file:" + javaKeystore;
                this.trustPassword = StringUtils.isEmpty((CharSequence)this.trustPassword) ? "changeit" : this.trustPassword;
                useTrustCert = true;
            } else if (useTrustCert && !this.trustKeystore.startsWith("http")) {
                this.trustKeystore = "file:" + this.trustKeystore;
            }
            this.createTrustKeystore(sslContextBuilder, useTrustCert);
            this.createKeystore(sslContextBuilder, useClientCert);
        } else {
            try {
                sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                });
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage() + ". " + TRUST_ALL_ROOTS_ERROR + trustAllRoots, e);
            }
        }
        sslContextBuilder.useSSL();
        sslContextBuilder.useTLS();
        try {
            X509HostnameVerifier x509HostnameVerifier;
            String x509HostnameVerifierStr;
            switch (x509HostnameVerifierStr = this.x509HostnameVerifierInputValue.toLowerCase()) {
                case "strict": {
                    x509HostnameVerifier = SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER;
                    break;
                }
                case "browser_compatible": {
                    x509HostnameVerifier = SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
                    break;
                }
                case "allow_all": {
                    x509HostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid value '" + this.x509HostnameVerifierInputValue + "' for input 'x509HostnameVerifier'. Valid values: 'strict','browser_compatible','allow_all'.");
                }
            }
            sslsf = new SSLConnectionSocketFactory(sslContextBuilder.build(), SUPPORTED_PROTOCOLS, null, x509HostnameVerifier);
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage() + ". " + SSL_CONNECTION_ERROR, e);
        }
        return sslsf;
    }

    protected void createKeystore(SSLContextBuilder sslContextBuilder, boolean useClientCert) {
        if (useClientCert) {
            try {
                KeyStore clientKeyStore = this.createKeyStore(new URL(this.keystore), this.keystorePassword);
                sslContextBuilder.loadKeyMaterial(clientKeyStore, this.keystorePassword.toCharArray());
            }
            catch (IOException | UnrecoverableKeyException ue) {
                throw new IllegalArgumentException(ue.getMessage() + ". " + BAD_KEYSTORE_ERROR, ue);
            }
            catch (GeneralSecurityException gse) {
                throw new IllegalArgumentException(gse.getMessage() + ". " + INVALID_KEYSTORE_ERROR, gse);
            }
        }
    }

    protected void createTrustKeystore(SSLContextBuilder sslContextBuilder, boolean useTrustCert) {
        if (useTrustCert) {
            try {
                KeyStore trustKeyStore = this.createKeyStore(new URL(this.trustKeystore), this.trustPassword);
                sslContextBuilder.loadTrustMaterial(trustKeyStore);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe.getMessage() + ". " + BAD_TRUST_KEYSTORE_ERROR, ioe);
            }
            catch (GeneralSecurityException gse) {
                throw new IllegalArgumentException(gse.getMessage() + ". " + INVALID_TRUST_KEYSTORE_ERROR, gse);
            }
        }
    }

    public SSLConnectionSocketFactoryBuilder setTrustAllRoots(String trustAllRoots) {
        if (!StringUtils.isEmpty((CharSequence)trustAllRoots)) {
            this.trustAllRootsStr = trustAllRoots;
        }
        return this;
    }

    public SSLConnectionSocketFactoryBuilder setKeystore(String keystore) {
        this.keystore = keystore;
        return this;
    }

    public SSLConnectionSocketFactoryBuilder setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public SSLConnectionSocketFactoryBuilder setTrustKeystore(String trustKeystore) {
        this.trustKeystore = trustKeystore;
        return this;
    }

    public SSLConnectionSocketFactoryBuilder setTrustPassword(String trustPassword) {
        this.trustPassword = trustPassword;
        return this;
    }

    public SSLConnectionSocketFactoryBuilder setX509HostnameVerifier(String x509HostnameVerifier) {
        if (!StringUtils.isEmpty((CharSequence)x509HostnameVerifier)) {
            this.x509HostnameVerifierInputValue = x509HostnameVerifier;
        }
        return this;
    }
}

