/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient.consume;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URIUtils;

public class FinalLocationConsumer {
    private URI uri;
    private HttpHost targetHost;
    private List<URI> redirectLocations;

    public FinalLocationConsumer setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    public FinalLocationConsumer setTargetHost(HttpHost targetHost) {
        this.targetHost = targetHost;
        return this;
    }

    public FinalLocationConsumer setRedirectLocations(List<URI> redirectLocations) {
        this.redirectLocations = redirectLocations;
        return this;
    }

    public void consume(Map<String, String> returnResult) {
        URI location;
        try {
            location = URIUtils.resolve((URI)this.uri, (HttpHost)this.targetHost, this.redirectLocations);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("could not determine 'finalLocation': " + e.getMessage(), e);
        }
        returnResult.put("finalLocation", location.toASCIIString());
    }
}

