/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient.consume;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.HeaderValueParser;

public class HttpResponseConsumer {
    private HttpResponse httpResponse;
    private String responseCharacterSet;
    private String destinationFile;

    public HttpResponseConsumer setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }

    public HttpResponseConsumer setResponseCharacterSet(String responseCharacterSet) {
        this.responseCharacterSet = responseCharacterSet;
        return this;
    }

    public HttpResponseConsumer setDestinationFile(String destinationFile) {
        this.destinationFile = destinationFile;
        return this;
    }

    public void consume(Map<String, String> result) throws IOException {
        if (this.httpResponse.getEntity() != null) {
            if (this.responseCharacterSet == null || this.responseCharacterSet.isEmpty()) {
                Header contentType = this.httpResponse.getEntity().getContentType();
                if (contentType != null) {
                    NameValuePair[] nameValuePairs;
                    String value = contentType.getValue();
                    for (NameValuePair nameValuePair : nameValuePairs = BasicHeaderValueParser.parseParameters((String)value, (HeaderValueParser)BasicHeaderValueParser.INSTANCE)) {
                        if (!nameValuePair.getName().equalsIgnoreCase("charset")) continue;
                        this.responseCharacterSet = nameValuePair.getValue();
                        break;
                    }
                }
                if (this.responseCharacterSet == null || this.responseCharacterSet.isEmpty()) {
                    this.responseCharacterSet = Consts.ISO_8859_1.name();
                }
            }
            this.consumeResponseContent(result);
        }
    }

    protected void consumeResponseContent(Map<String, String> result) throws IOException {
        if (StringUtils.isEmpty((CharSequence)this.destinationFile)) {
            String document;
            try {
                document = IOUtils.toString((InputStream)this.httpResponse.getEntity().getContent(), (String)this.responseCharacterSet);
            }
            catch (UnsupportedCharsetException e) {
                throw new IllegalArgumentException("Could not parse responseCharacterSet. " + e.getMessage(), e);
            }
            result.put("returnResult", document);
        } else {
            this.consumeToDestinationFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeToDestinationFile() throws IOException {
        BufferedWriter fileWriter = null;
        FileOutputStream fos = null;
        try {
            int b;
            BufferedReader reader;
            try {
                reader = new BufferedReader(new InputStreamReader(this.httpResponse.getEntity().getContent(), this.responseCharacterSet));
                fos = new FileOutputStream(new File(this.destinationFile));
                fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, this.responseCharacterSet));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Could not parse 'responseCharacterSet'. " + e.getMessage(), e);
            }
            char[] buffer = new char[1024];
            while ((b = reader.read(buffer, 0, buffer.length)) != -1) {
                fileWriter.write(buffer, 0, b);
            }
            fileWriter.flush();
            if (fos != null) {
                this.safeClose(fos);
            }
            if (fileWriter != null) {
                this.safeClose(fileWriter);
            }
        }
        catch (Throwable throwable) {
            if (fos != null) {
                this.safeClose(fos);
            }
            if (fileWriter != null) {
                this.safeClose(fileWriter);
            }
            throw throwable;
        }
    }

    private void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

