/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient.execute;

import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;

public class HttpClientExecutor {
    private HttpRequestBase httpRequestBase;
    private CloseableHttpClient closeableHttpClient;
    private HttpClientContext context;

    public HttpClientExecutor setHttpRequestBase(HttpRequestBase httpRequestBase) {
        this.httpRequestBase = httpRequestBase;
        return this;
    }

    public HttpClientExecutor setCloseableHttpClient(CloseableHttpClient closeableHttpClient) {
        this.closeableHttpClient = closeableHttpClient;
        return this;
    }

    public HttpClientExecutor setContext(HttpClientContext context) {
        this.context = context;
        return this;
    }

    public CloseableHttpResponse execute() {
        CloseableHttpResponse response;
        try {
            response = this.closeableHttpClient.execute((HttpUriRequest)this.httpRequestBase, (HttpContext)this.context);
        }
        catch (SocketTimeoutException ste) {
            throw new RuntimeException("Socket timeout: " + ste.getMessage(), ste);
        }
        catch (HttpHostConnectException connectEx) {
            throw new RuntimeException("Connection error: " + connectEx.getMessage(), connectEx);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while executing http request: " + e.getMessage(), e);
        }
        return response;
    }
}

