/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.samples.controlactions;

import io.cloudslang.score.api.EndBranchDataContainer;
import io.cloudslang.score.lang.ExecutionRuntimeServices;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BranchActions {
    public static final String STEP_POSITION = "stepPosition";
    public static final String EXECUTION_PLAN_ID = "executionPlanId";
    public static final String BRANCH_RESULTS = "branchResults";
    public static final String BRANCH_CONTEXTS = "branchContexts";
    public static final String PARALLEL_EXECUTION_PLAN_IDS = "parallelExecutionPlanIds";

    public void split(ExecutionRuntimeServices executionRuntimeServices, Long stepPosition, String executionPlanId) {
        executionRuntimeServices.addBranch(stepPosition, executionPlanId, new HashMap());
    }

    public void splitWithContext(ExecutionRuntimeServices executionRuntimeServices, Map<String, Serializable> executionContext, String flowUuid, Map<String, Serializable> context, List<String> inputKeysFromParentContext) {
        HashMap<String, Serializable> initialContext = new HashMap<String, Serializable>();
        initialContext.putAll(context);
        if (inputKeysFromParentContext != null) {
            for (String inputKey : inputKeysFromParentContext) {
                initialContext.put(inputKey, executionContext.get(inputKey));
            }
        }
        executionRuntimeServices.addBranch(Long.valueOf(0L), flowUuid, initialContext);
    }

    public void join(ExecutionRuntimeServices executionRuntimeServices, Map<String, Serializable> executionContext) {
        List branches = executionRuntimeServices.getFinishedChildBranchesData();
        for (EndBranchDataContainer branch : branches) {
            Map branchContext = branch.getContexts();
            executionContext.putAll(branchContext);
        }
    }

    public void joinBranches(ExecutionRuntimeServices executionRuntimeServices, Map<String, Serializable> executionContext) {
        List branches = executionRuntimeServices.getFinishedChildBranchesData();
        ArrayList<Map> branchResults = new ArrayList<Map>();
        for (EndBranchDataContainer branch : branches) {
            Map branchContext = branch.getContexts();
            branchResults.add(branchContext);
        }
        executionContext.put(BRANCH_RESULTS, branchResults);
    }

    public void parallelSplit(ExecutionRuntimeServices executionRuntimeServices, Long stepPosition, String executionPlanId) {
        executionRuntimeServices.addBranch(stepPosition, executionPlanId, new HashMap());
        executionRuntimeServices.addBranch(stepPosition, executionPlanId, new HashMap());
    }

    public void multiInstanceWithContext(ExecutionRuntimeServices executionRuntimeServices, Long stepPosition, String executionPlanId, Map<String, Serializable> executionContext) {
        List branchContexts = (List)((Object)executionContext.get(BRANCH_CONTEXTS));
        for (Map currentBranchContext : branchContexts) {
            executionRuntimeServices.addBranch(stepPosition, executionPlanId, currentBranchContext);
        }
    }

    public void parallelSplitWithContext(ExecutionRuntimeServices executionRuntimeServices, Long stepPosition, List<String> parallelExecutionPlanIds, Map<String, Serializable> executionContext) {
        List branchContexts = (List)((Object)executionContext.get(BRANCH_CONTEXTS));
        for (int i = 0; i < parallelExecutionPlanIds.size(); ++i) {
            executionRuntimeServices.addBranch(stepPosition, parallelExecutionPlanIds.get(i), (Map)branchContexts.get(i));
        }
    }
}

