/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.dependency.impl.services;

import io.cloudslang.dependency.api.services.DependencyService;
import io.cloudslang.dependency.api.services.MavenConfig;
import io.cloudslang.score.events.EventBus;
import io.cloudslang.score.events.ScoreEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Component
public class DependencyServiceImpl
implements DependencyService {
    private static final Logger logger = Logger.getLogger(DependencyServiceImpl.class);
    private static final String MAVEN_LAUNCHER_CLASS_NAME = "org.codehaus.plexus.classworlds.launcher.Launcher";
    private static final String MAVEN_LANUCHER_METHOD_NAME = "mainWithExitCode";
    private static final String PATH_FILE_EXTENSION = "path";
    private static final String GAV_DELIMITER = ":";
    private static final String PATH_FILE_DELIMITER = ";";
    private static final int MINIMAL_GAV_PARTS = 3;
    private static final int MAXIMAL_GAV_PARTS = 5;
    private static final String GAV_SEPARATOR = "_";
    private Method launcherMethod;
    @Value(value="#{systemProperties['maven.home']}")
    private String mavenHome;
    private ClassLoader mavenClassLoader;
    private Method MAVEN_EXECUTE_METHOD;
    private String mavenLogFolder;
    @Autowired
    private MavenConfig mavenConfig;
    @Autowired
    private EventBus eventBus;
    private final Lock lock = new ReentrantLock();

    @PostConstruct
    private void initMaven() throws ClassNotFoundException, NoSuchMethodException, MalformedURLException {
        File libDir;
        ClassLoader parentClassLoader = DependencyServiceImpl.class.getClassLoader();
        while (parentClassLoader.getParent() != null) {
            parentClassLoader = parentClassLoader.getParent();
        }
        if (this.isMavenConfigured() && (libDir = new File(this.mavenHome, "boot")).exists()) {
            URL[] mavenJarUrls = this.getUrls(libDir);
            this.mavenClassLoader = new URLClassLoader(mavenJarUrls, parentClassLoader);
            this.MAVEN_EXECUTE_METHOD = Class.forName(MAVEN_LAUNCHER_CLASS_NAME, true, this.mavenClassLoader).getMethod(MAVEN_LANUCHER_METHOD_NAME, String[].class);
            this.initMavenLogs();
        }
    }

    private void initMavenLogs() {
        File mavenLogFolderFile = new File(new File(this.calculateLogFolderPath()), "maven");
        boolean dirsCreated = mavenLogFolderFile.mkdirs();
        if (!dirsCreated) {
            logger.error((Object)("Failed to create maven log directories " + mavenLogFolderFile.getAbsolutePath()));
        }
        this.mavenLogFolder = mavenLogFolderFile.getAbsolutePath();
    }

    private String calculateLogFolderPath() {
        Enumeration e = Logger.getRootLogger().getAllAppenders();
        while (e.hasMoreElements()) {
            Appender app = (Appender)e.nextElement();
            if (!(app instanceof FileAppender)) continue;
            String logFile = ((FileAppender)app).getFile();
            return new File(logFile).getParentFile().getAbsolutePath();
        }
        return new File(System.getProperty("app.home"), "logs").getAbsolutePath();
    }

    protected PrintStream outputFile(String name) throws FileNotFoundException {
        File logFile = new File(name);
        File parentFile = logFile.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            logger.error((Object)("Failed to create parent folder [" + parentFile.getAbsolutePath() + "] for log file [" + name + "]"));
        }
        return new PrintStream(new BufferedOutputStream(new FileOutputStream(name)));
    }

    private boolean isMavenConfigured() {
        return this.mavenHome != null && !this.mavenHome.isEmpty();
    }

    private URL[] getUrls(File libDir) throws MalformedURLException {
        File[] mavenJars = libDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return StringUtils.endsWithIgnoreCase((String)name, (String)"jar");
            }
        });
        URL[] mavenJarUrls = new URL[mavenJars.length];
        for (int i = 0; i < mavenJarUrls.length; ++i) {
            mavenJarUrls[i] = mavenJars[i].toURI().toURL();
        }
        return mavenJarUrls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDependencies(Set<String> resources) {
        HashSet<String> resolvedResources = new HashSet<String>(resources.size());
        for (String resource : resources) {
            String[] gav = this.extractGav(resource);
            try {
                String dependencyFilePath = this.getResourceFolderPath(gav) + '/' + this.getPathFileName(gav);
                File file = new File(dependencyFilePath);
                if (!file.exists()) {
                    this.lock.lock();
                    try {
                        if (!file.exists()) {
                            this.buildDependencyFile(gav);
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                List<String> dependencyList = this.parse(file);
                resolvedResources.addAll(dependencyList);
            }
            catch (IOException | InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        return resolvedResources;
    }

    private void buildDependencyFile(String[] gav) throws InterruptedException {
        this.sendMavenDependencyBuildEvent(gav);
        String pomFilePath = this.getPomFilePath(gav);
        this.downloadArtifacts(gav);
        System.setProperty("mdep.outputFile", this.getPathFileName(gav));
        System.setProperty("mdep.pathSeparator", PATH_FILE_DELIMITER);
        System.setProperty("classworlds.conf", System.getProperty("maven.m2.conf.path"));
        String[] args = new String[]{"-s", System.getProperty("maven.settings.xml.path"), "-f", pomFilePath, "dependency:build-classpath", "--log-file", this.constructGavLogFilePath(gav, "build")};
        try {
            this.invokeMavenLauncher(args);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to build classpath using Maven", e);
        }
        File fileToReturn = new File(this.getResourceFolderPath(gav) + '/' + this.getPathFileName(gav));
        if (!fileToReturn.exists()) {
            throw new IllegalStateException(fileToReturn.getPath() + " not found");
        }
        this.appendSelfToPathFile(gav, fileToReturn);
        this.sendMavenDependencyBuildFinishedEvent(gav);
    }

    private void sendMavenDependencyBuildFinishedEvent(String[] gav) throws InterruptedException {
        String message = String.format("Download complete for artifact with gav: %s ", StringUtils.arrayToDelimitedString((Object[])gav, (String)GAV_DELIMITER));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("MAVEN_DEPENDENCY_BUILD_FINISHED", message);
        this.dispatchEvent(new ScoreEvent("MAVEN_DEPENDENCY_BUILD_FINISHED", (Serializable)data));
    }

    private void sendMavenDependencyBuildEvent(String[] gav) throws InterruptedException {
        String message = String.format("Downloading artifact with gav: %s ", StringUtils.arrayToDelimitedString((Object[])gav, (String)GAV_DELIMITER));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("MAVEN_DEPENDENCY_BUILD", message);
        this.dispatchEvent(new ScoreEvent("MAVEN_DEPENDENCY_BUILD", (Serializable)data));
    }

    private void dispatchEvent(ScoreEvent eventWrapper) throws InterruptedException {
        this.eventBus.dispatch(new ScoreEvent[]{eventWrapper});
    }

    private String getPomFilePath(String[] gav) {
        return this.getResourceFolderPath(gav) + '/' + this.getFileName(gav, "pom");
    }

    private String constructGavLogFilePath(String[] gav, String what) {
        return new File(this.mavenLogFolder, gav[0] + GAV_SEPARATOR + gav[1] + GAV_SEPARATOR + gav[2] + GAV_SEPARATOR + what + ".log").getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeMavenLauncher(String[] args) throws Exception {
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.mavenClassLoader);
        try {
            int exitCode = (Integer)this.MAVEN_EXECUTE_METHOD.invoke(null, new Object[]{args});
            if (exitCode != 0) {
                throw new RuntimeException("mvn " + StringUtils.arrayToDelimitedString((Object[])args, (String)" ") + " returned " + exitCode + ", see log for details");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
        }
    }

    private void downloadArtifacts(String[] gav) {
        this.getDependencies(gav, false);
        this.getDependencies(gav, true);
    }

    private void getDependencies(String[] gav, Boolean transitive) {
        System.setProperty("artifact", this.getResourceString(gav, transitive));
        System.setProperty("classworlds.conf", System.getProperty("maven.m2.conf.path"));
        System.setProperty("transitive", transitive.toString());
        String[] args = new String[]{"-s", System.getProperty("maven.settings.xml.path"), "dependency:get", "--log-file", this.constructGavLogFilePath(gav, "get")};
        try {
            this.invokeMavenLauncher(args);
            if (!transitive.booleanValue()) {
                this.removeTestScopeDependencies(gav);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to download resources using Maven", e);
        }
        finally {
            System.getProperties().remove("transitive");
        }
    }

    private void removeTestScopeDependencies(String[] gav) {
        String pomFilePath = this.getPomFilePath(gav);
        try {
            this.removeByXpathExpression(pomFilePath, "/project/dependencies/dependency[scope[contains(text(), 'test')]]");
            this.removeByXpathExpression(pomFilePath, "/project/dependencyManagement/dependencies/dependency[scope[contains(text(), 'test')]]");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void removeByXpathExpression(String pomFilePath, String expression) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException, TransformerException {
        File xmlFile = new File(pomFilePath);
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xmlFile);
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nl = (NodeList)xpath.compile(expression).evaluate(doc, XPathConstants.NODESET);
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                node.getParentNode().removeChild(node);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult output = new StreamResult(new File(pomFilePath).getPath());
            DOMSource input = new DOMSource(doc);
            transformer.transform(input, output);
        }
    }

    private void appendSelfToPathFile(String[] gav, File pathFile) {
        File resourceFolder = new File(this.getResourceFolderPath(gav));
        if (!resourceFolder.exists() || !resourceFolder.isDirectory()) {
            throw new IllegalStateException("Directory " + resourceFolder.getPath() + " not found");
        }
        File[] files = resourceFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar") || name.toLowerCase().endsWith(".zip");
            }
        });
        if (files.length == 0) {
            throw new IllegalStateException("No resource is found in " + resourceFolder.getPath());
        }
        File resourceFile = files[0];
        try (FileWriter fw = new FileWriter(pathFile, true);
             BufferedWriter bw = new BufferedWriter(fw);
             PrintWriter out = new PrintWriter(bw);){
            out.print(PATH_FILE_DELIMITER);
            out.print(resourceFile.getCanonicalPath());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to append to file " + pathFile.getParent(), e);
        }
    }

    private String getResourceString(String[] gav, boolean transitive) {
        Object[] newGav = new String[Math.max(4, gav.length)];
        System.arraycopy(gav, 0, newGav, 0, gav.length);
        if (!transitive) {
            newGav[3] = "pom";
        } else if (newGav[3] == null) {
            newGav[3] = "jar";
        }
        return StringUtils.arrayToDelimitedString((Object[])newGav, (String)GAV_DELIMITER);
    }

    private String getPathFileName(String[] gav) {
        return this.getFileName(gav, PATH_FILE_EXTENSION);
    }

    private String getFileName(String[] gav, String extension) {
        return this.getArtifactID(gav) + '-' + this.getVersion(gav) + "." + extension;
    }

    private List<String> parse(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line = reader.readLine();
            if (line.startsWith(PATH_FILE_DELIMITER)) {
                line = line.substring(PATH_FILE_DELIMITER.length());
            }
            String[] paths = line.split(PATH_FILE_DELIMITER);
            List<String> list = Arrays.asList(paths);
            return list;
        }
    }

    private String getResourceFolderPath(String[] gav) {
        return this.mavenConfig.getLocalMavenRepoPath() + '/' + this.getGroupIDPath(gav) + '/' + this.getArtifactID(gav) + '/' + this.getVersion(gav);
    }

    private String[] extractGav(String resource) {
        String[] gav = resource.split(GAV_DELIMITER);
        if (gav.length < 3 || gav.length > 5) {
            throw new IllegalArgumentException("Unexpected resource format: " + resource + ", should be <group ID>:<artifact ID>:<version> or <group ID>:<artifact ID>:<version>:<packaging> or <group ID>:<artifact ID>:<version>:<packaging>:<classifier>");
        }
        return gav;
    }

    private String getGroupIDPath(String[] gav) {
        return gav[0].replace('.', '/');
    }

    private String getArtifactID(String[] gav) {
        return gav[1];
    }

    private String getVersion(String[] gav) {
        return gav[2];
    }
}

