/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.samples;

import io.cloudslang.score.api.ControlActionMetadata;
import io.cloudslang.score.api.ExecutionPlan;
import io.cloudslang.score.api.ExecutionStep;
import io.cloudslang.score.api.Score;
import io.cloudslang.score.api.TriggeringProperties;
import io.cloudslang.score.events.EventBus;
import io.cloudslang.score.events.ScoreEvent;
import io.cloudslang.score.events.ScoreEventListener;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class HelloScore {
    @Autowired
    private Score score;
    @Autowired
    private EventBus eventBus;
    private static final Logger logger = Logger.getLogger(HelloScore.class);
    private ApplicationContext context;
    private final Object lock = new Object();

    public static void main(String[] args) {
        HelloScore app = HelloScore.loadApp();
        app.registerEventListener();
        app.start();
    }

    private static HelloScore loadApp() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("/META-INF/spring/helloScoreContext.xml");
        HelloScore app = (HelloScore)context.getBean(HelloScore.class);
        app.context = context;
        return app;
    }

    private void start() {
        ExecutionPlan executionPlan = HelloScore.createExecutionPlan();
        this.score.trigger(TriggeringProperties.create((ExecutionPlan)executionPlan));
        this.waitForExecutionToFinish();
        this.closeContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForExecutionToFinish() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait(10000L);
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getStackTrace());
        }
    }

    private static ExecutionPlan createExecutionPlan() {
        ExecutionPlan executionPlan = new ExecutionPlan();
        executionPlan.setFlowUuid("1");
        executionPlan.setBeginStep(Long.valueOf(0L));
        ExecutionStep executionStep = new ExecutionStep(Long.valueOf(0L));
        executionStep.setAction(new ControlActionMetadata("ConsoleControlActions", "echoHelloScore"));
        executionStep.setActionData(new HashMap());
        executionStep.setNavigation(new ControlActionMetadata("NavigationActions", "nextStepNavigation"));
        executionStep.setNavigationData(new HashMap());
        executionPlan.addStep(executionStep);
        ExecutionStep executionStep2 = new ExecutionStep(Long.valueOf(1L));
        executionStep2.setAction(new ControlActionMetadata("ConsoleControlActions", "echoHelloScore"));
        executionStep2.setActionData(new HashMap());
        executionPlan.addStep(executionStep2);
        return executionPlan;
    }

    private void registerEventListener() {
        HashSet<String> handlerTypes = new HashSet<String>();
        handlerTypes.add("SCORE_FINISHED_EVENT");
        handlerTypes.add("SCORE_FAILURE_EVENT");
        this.eventBus.subscribe(new ScoreEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onEvent(ScoreEvent event) {
                logger.info((Object)("Listener " + this.toString() + " invoked on type: " + event.getEventType() + " with data: " + event.getData()));
                Object object = HelloScore.this.lock;
                synchronized (object) {
                    HelloScore.this.lock.notify();
                }
            }
        }, handlerTypes);
    }

    private void closeContext() {
        ((ConfigurableApplicationContext)this.context).close();
    }
}

