/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python.external;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudslang.runtime.api.python.PythonEvaluationResult;
import io.cloudslang.runtime.api.python.PythonExecutionResult;
import io.cloudslang.runtime.impl.python.external.EvaluationResults;
import io.cloudslang.runtime.impl.python.external.ExternalPythonEvalException;
import io.cloudslang.runtime.impl.python.external.ExternalPythonScriptException;
import io.cloudslang.runtime.impl.python.external.ScriptResults;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExternalPythonExecutor {
    private static final String PYTHON_SCRIPT_FILENAME = "script";
    private static final String PYTHON_MAIN_FILENAME = "main";
    private static final String PYTHON_EVAL_FILENAME = "eval";
    private static final String PYTHON_SUFFIX = ".py";
    private static final Logger logger = Logger.getLogger(ExternalPythonExecutor.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final long EXECUTION_TIMEOUT = Long.getLong("python.timeout", 30L);
    private static final String PYTHON_FILENAME_SCRIPT_EXTENSION = ".py\"";
    private static final int PYTHON_FILENAME_DELIMITERS = 6;

    public PythonExecutionResult exec(String script, Map<String, Serializable> inputs) {
        PythonExecutionResult pythonExecutionResult;
        TempExecutionEnvironment tempExecutionEnvironment = null;
        try {
            String pythonPath = this.checkPythonPath();
            tempExecutionEnvironment = this.generateTempExecutionResources(script);
            String payload = this.generateExecutionPayload(tempExecutionEnvironment.userScriptName, inputs);
            this.addFilePermissions(tempExecutionEnvironment.parentFolder);
            pythonExecutionResult = this.runPythonExecutionProcess(pythonPath, payload, tempExecutionEnvironment);
        }
        catch (IOException e) {
            try {
                String message = "Failed to generate execution resources";
                logger.error((Object)message, (Throwable)e);
                throw new RuntimeException(message);
            }
            catch (Throwable throwable) {
                if (tempExecutionEnvironment != null && !FileUtils.deleteQuietly((File)tempExecutionEnvironment.parentFolder) && tempExecutionEnvironment.parentFolder != null) {
                    logger.warn((Object)String.format("Failed to cleanup python execution resources {%s}", tempExecutionEnvironment.parentFolder));
                }
                throw throwable;
            }
        }
        if (tempExecutionEnvironment != null && !FileUtils.deleteQuietly((File)tempExecutionEnvironment.parentFolder) && tempExecutionEnvironment.parentFolder != null) {
            logger.warn((Object)String.format("Failed to cleanup python execution resources {%s}", tempExecutionEnvironment.parentFolder));
        }
        return pythonExecutionResult;
    }

    public PythonEvaluationResult eval(String expression, String prepareEnvironmentScript, Map<String, Serializable> context) {
        PythonEvaluationResult pythonEvaluationResult;
        TempEvalEnvironment tempEvalEnvironment = null;
        try {
            String pythonPath = this.checkPythonPath();
            tempEvalEnvironment = this.generateTempEvalResources();
            String payload = this.generateEvalPayload(expression, prepareEnvironmentScript, context);
            this.addFilePermissions(tempEvalEnvironment.parentFolder);
            pythonEvaluationResult = this.runPythonEvalProcess(pythonPath, payload, tempEvalEnvironment, context);
        }
        catch (IOException e) {
            try {
                String message = "Failed to generate execution resources";
                logger.error((Object)message, (Throwable)e);
                throw new RuntimeException(message);
            }
            catch (Throwable throwable) {
                if (tempEvalEnvironment != null && !FileUtils.deleteQuietly((File)tempEvalEnvironment.parentFolder) && tempEvalEnvironment.parentFolder != null) {
                    logger.warn((Object)String.format("Failed to cleanup python execution resources {%s}", tempEvalEnvironment.parentFolder));
                }
                throw throwable;
            }
        }
        if (tempEvalEnvironment != null && !FileUtils.deleteQuietly((File)tempEvalEnvironment.parentFolder) && tempEvalEnvironment.parentFolder != null) {
            logger.warn((Object)String.format("Failed to cleanup python execution resources {%s}", tempEvalEnvironment.parentFolder));
        }
        return pythonEvaluationResult;
    }

    private void addFilePermissions(File file) throws IOException {
        HashSet<PosixFilePermission> filePermissions = new HashSet<PosixFilePermission>();
        filePermissions.add(PosixFilePermission.OWNER_READ);
        File[] fileChildren = file.listFiles();
        if (fileChildren != null) {
            for (File child : fileChildren) {
                if (SystemUtils.IS_OS_WINDOWS) {
                    child.setReadOnly();
                    continue;
                }
                Files.setPosixFilePermissions(child.toPath(), filePermissions);
            }
        }
    }

    private String checkPythonPath() {
        String pythonPath = System.getProperty("python.path");
        if (StringUtils.isEmpty((String)pythonPath) || !new File(pythonPath).exists()) {
            throw new IllegalArgumentException("Missing or invalid python path");
        }
        return pythonPath;
    }

    private Document parseScriptExecutionResult(String scriptExecutionResult) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(scriptExecutionResult));
        return db.parse(is);
    }

    private PythonExecutionResult runPythonExecutionProcess(String pythonPath, String payload, TempExecutionEnvironment executionEnvironment) {
        ProcessBuilder processBuilder = this.preparePythonProcess(executionEnvironment, pythonPath);
        try {
            String returnResult = this.getResult(payload, processBuilder);
            returnResult = this.parseScriptExecutionResult(returnResult).getElementsByTagName("result").item(0).getTextContent();
            ScriptResults scriptResults = (ScriptResults)objectMapper.readValue(returnResult, ScriptResults.class);
            String exception = this.formatException(scriptResults.getException(), scriptResults.getTraceback());
            if (!StringUtils.isEmpty((String)exception)) {
                logger.error((Object)String.format("Failed to execute script {%s}", exception));
                throw new ExternalPythonScriptException(String.format("Failed to execute user script: %s", exception));
            }
            return new PythonExecutionResult(scriptResults.getReturnResult());
        }
        catch (IOException | InterruptedException | ParserConfigurationException | SAXException e) {
            logger.error((Object)"Failed to run script. ", e.getCause() != null ? e.getCause() : e);
            throw new RuntimeException("Failed to run script.");
        }
    }

    private PythonEvaluationResult runPythonEvalProcess(String pythonPath, String payload, TempEvalEnvironment executionEnvironment, Map<String, Serializable> context) {
        ProcessBuilder processBuilder = this.preparePythonProcess(executionEnvironment, pythonPath);
        try {
            String returnResult = this.getResult(payload, processBuilder);
            EvaluationResults scriptResults = (EvaluationResults)objectMapper.readValue(returnResult, EvaluationResults.class);
            String exception = scriptResults.getException();
            if (!StringUtils.isEmpty((String)exception)) {
                logger.error((Object)String.format("Failed to execute script {%s}", exception));
                throw new ExternalPythonEvalException(exception);
            }
            context.put("accessed_resources_set", (Serializable)((Object)scriptResults.getAccessedResources()));
            return new PythonEvaluationResult(this.processReturnResult(scriptResults), context);
        }
        catch (IOException | InterruptedException e) {
            logger.error((Object)"Failed to run script. ", e.getCause() != null ? e.getCause() : e);
            throw new RuntimeException("Failed to run script.");
        }
    }

    private Serializable processReturnResult(EvaluationResults results) {
        EvaluationResults.ReturnType returnType = results.getReturnType();
        if (returnType == null) {
            throw new RuntimeException("Missing return type for return result.");
        }
        switch (returnType) {
            case BOOLEAN: {
                return Boolean.valueOf(results.getReturnResult());
            }
            case INTEGER: {
                return Integer.valueOf(results.getReturnResult());
            }
        }
        return results.getReturnResult();
    }

    private String getResult(String payload, ProcessBuilder processBuilder) throws IOException, InterruptedException {
        String line;
        Process process = processBuilder.start();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8));
        printWriter.println(payload);
        printWriter.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuilder returnResult = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            returnResult.append(line);
        }
        boolean isInTime = process.waitFor(EXECUTION_TIMEOUT, TimeUnit.MINUTES);
        if (!isInTime) {
            process.destroy();
            throw new RuntimeException("Execution timed out");
        }
        if (process.exitValue() != 0) {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)process.getErrorStream(), (Writer)writer, (Charset)StandardCharsets.UTF_8);
            logger.error((Object)writer.toString());
            throw new RuntimeException("Execution returned non 0 result");
        }
        return returnResult.toString();
    }

    private ProcessBuilder preparePythonProcess(TempEnvironment executionEnvironment, String pythonPath) {
        ProcessBuilder processBuilder = new ProcessBuilder(Arrays.asList(Paths.get(pythonPath, "python").toString(), Paths.get(executionEnvironment.parentFolder.toString(), executionEnvironment.mainScriptName).toString()));
        processBuilder.environment().clear();
        processBuilder.directory(executionEnvironment.parentFolder);
        return processBuilder;
    }

    private TempExecutionEnvironment generateTempExecutionResources(String script) throws IOException {
        Path execTempDirectory = Files.createTempDirectory("python_execution", new FileAttribute[0]);
        File tempUserScript = File.createTempFile(PYTHON_SCRIPT_FILENAME, PYTHON_SUFFIX, execTempDirectory.toFile());
        FileUtils.writeStringToFile((File)tempUserScript, (String)script, (Charset)StandardCharsets.UTF_8);
        ClassLoader classLoader = ExternalPythonExecutor.class.getClassLoader();
        Path mainScriptPath = Paths.get(execTempDirectory.toString(), "main.py");
        Files.copy(classLoader.getResourceAsStream("main.py"), mainScriptPath, new CopyOption[0]);
        String tempUserScriptName = FilenameUtils.getName((String)tempUserScript.toString());
        String mainScriptName = FilenameUtils.getName((String)mainScriptPath.toString());
        return new TempExecutionEnvironment(tempUserScriptName, mainScriptName, execTempDirectory.toFile());
    }

    private TempEvalEnvironment generateTempEvalResources() throws IOException {
        Path execTempDirectory = Files.createTempDirectory("python_expression", new FileAttribute[0]);
        ClassLoader classLoader = ExternalPythonExecutor.class.getClassLoader();
        Path mainScriptPath = Paths.get(execTempDirectory.toString(), "eval.py");
        Files.copy(classLoader.getResourceAsStream("eval.py"), mainScriptPath, new CopyOption[0]);
        String mainScriptName = FilenameUtils.getName((String)mainScriptPath.toString());
        return new TempEvalEnvironment(mainScriptName, execTempDirectory.toFile());
    }

    private String generateEvalPayload(String expression, String prepareEnvironmentScript, Map<String, Serializable> context) throws JsonProcessingException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("expression", expression);
        payload.put("envSetup", prepareEnvironmentScript);
        payload.put("context", (Serializable)((Object)context));
        return objectMapper.writeValueAsString(payload);
    }

    private String generateExecutionPayload(String userScript, Map<String, Serializable> inputs) throws JsonProcessingException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        HashMap parsedInputs = new HashMap();
        inputs.forEach((key, value) -> parsedInputs.put(key, value.toString()));
        payload.put("script_name", FilenameUtils.removeExtension((String)userScript));
        payload.put("inputs", parsedInputs);
        return objectMapper.writeValueAsString(payload);
    }

    private String formatException(String exception, List<String> traceback) {
        if (CollectionUtils.isEmpty(traceback)) {
            return exception;
        }
        return this.removeFileName(traceback.get(traceback.size() - 1)) + ", " + exception;
    }

    private String removeFileName(String trace) {
        int pythonFileNameIndex = trace.indexOf(PYTHON_FILENAME_SCRIPT_EXTENSION);
        return trace.substring(pythonFileNameIndex + 6);
    }

    private class TempEvalEnvironment
    extends TempEnvironment {
        private TempEvalEnvironment(String mainScriptName, File parentFolder) {
            super(mainScriptName, parentFolder);
        }
    }

    private class TempExecutionEnvironment
    extends TempEnvironment {
        private final String userScriptName;

        private TempExecutionEnvironment(String userScriptName, String mainScriptName, File parentFolder) {
            super(mainScriptName, parentFolder);
            this.userScriptName = userScriptName;
        }
    }

    private class TempEnvironment {
        final String mainScriptName;
        final File parentFolder;

        private TempEnvironment(String mainScriptName, File parentFolder) {
            this.mainScriptName = mainScriptName;
            this.parentFolder = parentFolder;
        }
    }
}

