/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python.external;

import io.cloudslang.runtime.api.python.PythonEvaluationResult;
import io.cloudslang.runtime.api.python.PythonExecutionResult;
import io.cloudslang.runtime.api.python.PythonRuntimeService;
import io.cloudslang.runtime.impl.python.external.ExternalPythonExecutionEngine;
import io.cloudslang.runtime.impl.python.external.ExternalPythonScriptException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.log4j.Logger;

public class ExternalPythonRuntimeServiceImpl
implements PythonRuntimeService {
    private static final Logger logger = Logger.getLogger(ExternalPythonRuntimeServiceImpl.class);
    private final Semaphore executionControlSemaphore;
    @Resource(name="externalPythonExecutionEngine")
    private ExternalPythonExecutionEngine externalPythonExecutionEngine;

    public ExternalPythonRuntimeServiceImpl(Semaphore executionControlSemaphore) {
        this.executionControlSemaphore = executionControlSemaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PythonExecutionResult exec(Set<String> dependencies, String script, Map<String, Serializable> vars) {
        try {
            if (this.executionControlSemaphore.tryAcquire(1L, TimeUnit.SECONDS)) {
                try {
                    PythonExecutionResult pythonExecutionResult = this.externalPythonExecutionEngine.exec(dependencies, script, vars);
                    return pythonExecutionResult;
                }
                finally {
                    this.executionControlSemaphore.release();
                }
            }
            logger.warn((Object)"Maximum number of python processes has been reached. Waiting for a python process to finish. You can configure the number of concurrent python executions by setting 'python.concurrent.execution.permits' system property.");
            this.executionControlSemaphore.acquire();
            try {
                logger.info((Object)"Acquired a permit for a new python process. Continuing with execution...");
                PythonExecutionResult pythonExecutionResult = this.externalPythonExecutionEngine.exec(dependencies, script, vars);
                return pythonExecutionResult;
            }
            finally {
                this.executionControlSemaphore.release();
            }
        }
        catch (InterruptedException ie) {
            throw new ExternalPythonScriptException("Execution was interrupted while waiting for a python permit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PythonEvaluationResult eval(String prepareEnvironmentScript, String script, Map<String, Serializable> vars) {
        try {
            if (this.executionControlSemaphore.tryAcquire(1L, TimeUnit.SECONDS)) {
                try {
                    PythonEvaluationResult pythonEvaluationResult = this.externalPythonExecutionEngine.eval(prepareEnvironmentScript, script, vars);
                    return pythonEvaluationResult;
                }
                finally {
                    this.executionControlSemaphore.release();
                }
            }
            logger.warn((Object)"Maximum number of python processes has been reached. Waiting for a python process to finish. You can configure the number of concurrent python executions by setting 'python.concurrent.execution.permits' system property.");
            this.executionControlSemaphore.acquire();
            try {
                logger.info((Object)"Acquired a permit for a new python process. Continuing with execution...");
                PythonEvaluationResult pythonEvaluationResult = this.externalPythonExecutionEngine.eval(prepareEnvironmentScript, script, vars);
                return pythonEvaluationResult;
            }
            finally {
                this.executionControlSemaphore.release();
            }
        }
        catch (InterruptedException ie) {
            throw new ExternalPythonScriptException("Execution was interrupted while waiting for a python permit.");
        }
    }
}

