/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl;

import io.cloudslang.dependency.api.services.DependencyService;
import io.cloudslang.runtime.impl.ExecutionEngine;
import io.cloudslang.runtime.impl.Executor;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ExecutionCachedEngine<T extends Executor>
extends ExecutionEngine {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Map<String, T> executors = new LinkedHashMap<String, T>();
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T allocateExecutor(Set<String> dependencies) {
        Executor executor;
        String dependenciesKey = this.generatedDependenciesKey(dependencies);
        Executor candidateForRemove = null;
        this.lock.lock();
        try {
            executor = (Executor)this.executors.get(dependenciesKey);
            if (executor == null) {
                int cacheSize = this.getCacheSize();
                if (this.executors.size() == cacheSize) {
                    this.logger.info("Reached cached executors limit[" + cacheSize + "], replacing LRU executor.");
                    Iterator<Map.Entry<String, T>> iterator = this.executors.entrySet().iterator();
                    candidateForRemove = (Executor)iterator.next().getValue();
                    iterator.remove();
                }
                executor = this.createNewExecutor(this.getDependencyService().getDependencies(dependencies));
            } else {
                this.executors.remove(dependenciesKey);
            }
            executor.allocate();
            this.executors.put(dependenciesKey, executor);
        }
        finally {
            this.lock.unlock();
        }
        if (candidateForRemove != null) {
            candidateForRemove.close();
        }
        return (T)executor;
    }

    protected void releaseExecutor(T executor) {
        executor.release();
    }

    protected abstract DependencyService getDependencyService();

    protected abstract int getCacheSize();

    protected abstract T createNewExecutor(Set<String> var1);
}

