/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.java;

import io.cloudslang.dependency.api.services.DependencyService;
import io.cloudslang.runtime.api.java.JavaExecutionParametersProvider;
import io.cloudslang.runtime.impl.ExecutionCachedEngine;
import io.cloudslang.runtime.impl.java.JavaExecutionEngine;
import io.cloudslang.runtime.impl.java.JavaExecutor;
import java.util.Set;
import org.python.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class JavaExecutionCachedEngine
extends ExecutionCachedEngine<JavaExecutor>
implements JavaExecutionEngine {
    @Autowired
    private DependencyService dependencyService;
    @Value(value="#{systemProperties['java.executor.cache.size'] != null ? systemProperties['java.executor.cache.size'] : 200}")
    private int cacheSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(String dependency, String className, String methodName, JavaExecutionParametersProvider parametersProvider) {
        JavaExecutor executor = (JavaExecutor)this.allocateExecutor(dependency == null || dependency.isEmpty() ? Sets.newHashSet() : Sets.newHashSet((Object[])new String[]{dependency}));
        try {
            Object object = executor.execute(className, methodName, parametersProvider);
            return object;
        }
        finally {
            this.releaseExecutor(executor);
        }
    }

    @Override
    protected DependencyService getDependencyService() {
        return this.dependencyService;
    }

    @Override
    protected int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    protected JavaExecutor createNewExecutor(Set<String> filePaths) {
        return new JavaExecutor(filePaths);
    }
}

