/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.java;

import io.cloudslang.dependency.impl.services.DependenciesManagementConfiguration;
import io.cloudslang.runtime.api.java.JavaRuntimeService;
import io.cloudslang.runtime.impl.java.JavaExecutionCachedEngine;
import io.cloudslang.runtime.impl.java.JavaExecutionEngine;
import io.cloudslang.runtime.impl.java.JavaExecutionNoCachedEngine;
import io.cloudslang.runtime.impl.java.JavaRuntimeServiceImpl;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ComponentScan(value={"io.cloudslang.runtime.impl.java"})
@Import(value={DependenciesManagementConfiguration.class})
public class JavaExecutionEngineConfiguration {
    @Bean
    public JavaRuntimeService javaRuntimeService() {
        return new JavaRuntimeServiceImpl();
    }

    @Bean
    public JavaExecutionEngine javaExecutionEngine() {
        String noCacheEngine = JavaExecutionNoCachedEngine.class.getSimpleName();
        String cacheEngine = JavaExecutionCachedEngine.class.getSimpleName();
        return System.getProperty("java.executor.engine", cacheEngine).equals(noCacheEngine) ? new JavaExecutionNoCachedEngine() : new JavaExecutionCachedEngine();
    }
}

