/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python;

import io.cloudslang.dependency.impl.services.DependenciesManagementConfiguration;
import io.cloudslang.runtime.api.python.PythonRuntimeService;
import io.cloudslang.runtime.impl.python.PythonExecutionCachedEngine;
import io.cloudslang.runtime.impl.python.PythonExecutionEngine;
import io.cloudslang.runtime.impl.python.PythonExecutionNotCachedEngine;
import io.cloudslang.runtime.impl.python.PythonRuntimeServiceImpl;
import io.cloudslang.runtime.impl.python.external.ExternalPythonExecutionEngine;
import io.cloudslang.runtime.impl.python.external.ExternalPythonRuntimeServiceImpl;
import java.util.concurrent.Semaphore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ComponentScan(value={"io.cloudslang.runtime.impl.python"})
@Import(value={DependenciesManagementConfiguration.class})
public class PythonExecutionEngineConfiguration {
    @Bean(name={"jythonRuntimeService"})
    public PythonRuntimeService pythonRuntimeService() {
        return new PythonRuntimeServiceImpl();
    }

    @Bean(name={"externalPythonRuntimeService"})
    public PythonRuntimeService externalPythonRuntimeService() {
        Integer pythonProcessPermits = Integer.getInteger("python.concurrent.execution.permits", 30);
        Integer pythonTestingProcessPermits = Integer.getInteger("python.testing.concurrent.execution.permits", 10);
        return new ExternalPythonRuntimeServiceImpl(new Semaphore(pythonProcessPermits), new Semaphore(pythonTestingProcessPermits));
    }

    @Bean(name={"jythonExecutionEngine"})
    PythonExecutionEngine pythonExecutionEngine() {
        String noCacheEngine = PythonExecutionNotCachedEngine.class.getSimpleName();
        String cacheEngine = PythonExecutionCachedEngine.class.getSimpleName();
        return System.getProperty("python.executor.engine", cacheEngine).equals(noCacheEngine) ? new PythonExecutionNotCachedEngine() : new PythonExecutionCachedEngine();
    }

    @Bean(name={"externalPythonExecutionEngine"})
    PythonExecutionEngine externalPythonExecutionEngine() {
        return new ExternalPythonExecutionEngine();
    }
}

