/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python.external;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class ExternalPythonEvaluationSupplier
implements Supplier<String> {
    private final AtomicReference<Process> processRef = new AtomicReference();
    private final ProcessBuilder processBuilder;
    private final String payload;

    public ExternalPythonEvaluationSupplier(ProcessBuilder processBuilder, String payload) {
        this.processBuilder = processBuilder;
        this.payload = payload;
    }

    @Override
    public String get() {
        try {
            String line;
            Process process = this.processBuilder.start();
            this.processRef.set(process);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8));
            printWriter.println(this.payload);
            printWriter.flush();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder returnResult = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                returnResult.append(line);
            }
            return returnResult.toString();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Script execution failed: ", ioException);
        }
    }

    public void destroyProcess() {
        try {
            Process process = this.processRef.get();
            if (process != null) {
                process.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

