/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python.external;

import io.cloudslang.runtime.api.python.ExternalPythonProcessRunService;
import io.cloudslang.runtime.api.python.PythonEvaluationResult;
import io.cloudslang.runtime.api.python.PythonExecutionResult;
import io.cloudslang.runtime.impl.python.PythonExecutionEngine;
import io.cloudslang.runtime.impl.python.external.ExternalPythonExecutorCompletableFutureTimeout;
import io.cloudslang.runtime.impl.python.external.ExternalPythonExecutorScheduledExecutorTimeout;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExternalPythonExecutionEngine
implements PythonExecutionEngine {
    private static final Logger logger = LogManager.getLogger(ExternalPythonExecutionEngine.class);
    private static final Supplier<ExternalPythonProcessRunService> pythonRunServiceSupplier;
    public static final String SCHEDULED_EXECUTOR_STRATEGY = "scheduled-executor";
    public static final String COMPLETABLE_EXECUTOR_STRATEGY = "completable-future";

    @Override
    public PythonExecutionResult exec(Set<String> dependencies, String script, Map<String, Serializable> vars) {
        ExternalPythonProcessRunService pythonExecutor = pythonRunServiceSupplier.get();
        return pythonExecutor.exec(script, vars);
    }

    @Override
    public PythonEvaluationResult eval(String prepareEnvironmentScript, String script, Map<String, Serializable> vars) {
        ExternalPythonProcessRunService pythonExecutor = pythonRunServiceSupplier.get();
        return pythonExecutor.eval(script, prepareEnvironmentScript, vars);
    }

    @Override
    public PythonEvaluationResult test(String prepareEnvironmentScript, String script, Map<String, Serializable> vars, long timeout) {
        ExternalPythonProcessRunService pythonExecutor = pythonRunServiceSupplier.get();
        return pythonExecutor.test(script, prepareEnvironmentScript, vars, timeout);
    }

    static {
        String timeoutStrategy = System.getProperty("python.timeoutStrategy", SCHEDULED_EXECUTOR_STRATEGY);
        pythonRunServiceSupplier = StringUtils.equalsIgnoreCase((CharSequence)timeoutStrategy, (CharSequence)SCHEDULED_EXECUTOR_STRATEGY) ? () -> new ExternalPythonExecutorScheduledExecutorTimeout() : (StringUtils.equalsIgnoreCase((CharSequence)timeoutStrategy, (CharSequence)COMPLETABLE_EXECUTOR_STRATEGY) ? () -> new ExternalPythonExecutorCompletableFutureTimeout() : () -> new ExternalPythonExecutorScheduledExecutorTimeout());
        logger.info("python timeout strategy: " + pythonRunServiceSupplier.get().getStrategyName());
    }
}

