/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl;

import io.cloudslang.dependency.api.services.DependencyService;
import io.cloudslang.runtime.impl.ExecutionEngine;
import io.cloudslang.runtime.impl.Executor;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class ExecutionCachedEngine<T extends Executor>
extends ExecutionEngine {
    private final Map<String, T> executors = new LinkedHashMap<String, T>();
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T allocateExecutor(Set<String> dependencies) {
        String dependenciesKey = this.generatedDependenciesKey(dependencies);
        Executor executor = (Executor)this.executors.get(dependenciesKey);
        Set filePaths = null;
        if (executor == null) {
            filePaths = this.getDependencyService().getDependencies(dependencies);
        }
        Executor candidateForRemove = null;
        try {
            this.lock.lock();
            if (executor == null) {
                if (this.executors.size() == this.getCacheSize()) {
                    Iterator<Map.Entry<String, T>> iterator = this.executors.entrySet().iterator();
                    candidateForRemove = (Executor)iterator.next().getValue();
                    iterator.remove();
                }
                executor = this.createNewExecutor(filePaths);
            } else {
                this.executors.remove(dependenciesKey);
            }
            executor.allocate();
            this.executors.put(dependenciesKey, executor);
        }
        finally {
            this.lock.unlock();
        }
        if (candidateForRemove != null) {
            candidateForRemove.close();
        }
        return (T)executor;
    }

    protected void releaseExecutor(T executor) {
        executor.release();
    }

    protected abstract DependencyService getDependencyService();

    protected abstract int getCacheSize();

    protected abstract T createNewExecutor(Set<String> var1);
}

