/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.java;

import io.cloudslang.runtime.api.java.JavaExecutionParametersProvider;
import io.cloudslang.runtime.impl.Executor;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.python.google.common.collect.Sets;

public class JavaExecutor
implements Executor {
    private static final String SCORE_CONTENT_SDK_JAR = "score-content-sdk*.jar";
    private static final String APP_HOME = "app.home";
    private static final ClassLoader PARENT_CLASS_LOADER;
    private final ClassLoader classLoader;

    JavaExecutor(Set<String> filePaths) {
        if (!filePaths.isEmpty()) {
            HashSet result = Sets.newHashSet();
            for (String filePath : filePaths) {
                try {
                    result.add(new File(filePath).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            this.classLoader = new URLClassLoader(result.toArray(new URL[result.size()]), PARENT_CLASS_LOADER);
        } else {
            this.classLoader = this.getClass().getClassLoader();
        }
    }

    Object execute(String className, String methodName, JavaExecutionParametersProvider parametersProvider) {
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Class actionClass = this.getActionClass(className);
            Method executionMethod = this.getMethodByName(actionClass, methodName);
            Object object = executionMethod.invoke(actionClass.newInstance(), parametersProvider.getExecutionParameters(executionMethod));
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("Method [" + methodName + "] invocation of class [" + className + "] failed!!!!", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
        }
    }

    private Class getActionClass(String className) {
        Class<?> actionClass;
        try {
            actionClass = Class.forName(className, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class name " + className + " was not found", e);
        }
        return actionClass;
    }

    private Method getMethodByName(Class actionClass, String methodName) {
        Method[] methods = actionClass.getDeclaredMethods();
        Method actionMethod = null;
        for (Method m : methods) {
            if (!m.getName().equals(methodName)) continue;
            actionMethod = m;
        }
        return actionMethod;
    }

    @Override
    public void allocate() {
    }

    @Override
    public void release() {
    }

    @Override
    public void close() {
    }

    static {
        ClassLoader parentClassLoader = JavaExecutor.class.getClassLoader();
        while (parentClassLoader.getParent() != null) {
            parentClassLoader = parentClassLoader.getParent();
        }
        URL[] parentUrls = new URL[]{};
        try {
            Collection foundFiles;
            String appHomeDir = System.getProperty(APP_HOME);
            File appLibDir = new File(appHomeDir, "lib");
            if (appLibDir.exists() && appLibDir.isDirectory() && (foundFiles = FileUtils.listFiles((File)appLibDir, (IOFileFilter)new WildcardFileFilter(SCORE_CONTENT_SDK_JAR), (IOFileFilter)DirectoryFileFilter.DIRECTORY)) != null && !foundFiles.isEmpty()) {
                for (File file : foundFiles) {
                    parentUrls = new URL[]{file.toURI().toURL()};
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        PARENT_CLASS_LOADER = new URLClassLoader(parentUrls, parentClassLoader);
    }
}

