/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python;

import io.cloudslang.dependency.api.services.DependencyService;
import io.cloudslang.runtime.api.python.PythonEvaluationResult;
import io.cloudslang.runtime.api.python.PythonExecutionResult;
import io.cloudslang.runtime.impl.ExecutionCachedEngine;
import io.cloudslang.runtime.impl.python.PythonExecutionEngine;
import io.cloudslang.runtime.impl.python.PythonExecutor;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.python.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class PythonExecutionCachedEngine
extends ExecutionCachedEngine<PythonExecutor>
implements PythonExecutionEngine {
    @Autowired
    private DependencyService dependencyService;
    @Value(value="#{systemProperties['python.executor.cache.size'] != null ? systemProperties['python.executor.cache.size'] : 200}")
    private int cacheSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PythonExecutionResult exec(Set<String> dependencies, String script, Map<String, Serializable> vars) {
        PythonExecutor executor = (PythonExecutor)this.allocateExecutor(dependencies);
        try {
            PythonExecutionResult pythonExecutionResult = executor.exec(script, vars);
            return pythonExecutionResult;
        }
        finally {
            this.releaseExecutor(executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PythonEvaluationResult eval(String prepareEnvironmentScript, String script, Map<String, Serializable> vars) {
        PythonExecutor executor = (PythonExecutor)this.allocateExecutor(Sets.newHashSet());
        try {
            PythonEvaluationResult pythonEvaluationResult = executor.eval(prepareEnvironmentScript, script, vars);
            return pythonEvaluationResult;
        }
        finally {
            this.releaseExecutor(executor);
        }
    }

    @Override
    protected DependencyService getDependencyService() {
        return this.dependencyService;
    }

    @Override
    protected int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    protected PythonExecutor createNewExecutor(Set<String> filePaths) {
        return new PythonExecutor(filePaths);
    }
}

