/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.java;

import io.cloudslang.runtime.api.java.JavaExecutionParametersProvider;
import io.cloudslang.runtime.impl.Executor;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.python.google.common.collect.Sets;

public class JavaExecutor
implements Executor {
    private static final Logger logger = LogManager.getLogger(JavaExecutor.class);
    private static final String SCORE_CONTENT_SDK_JAR = "score-content-sdk*.jar";
    private static final String APP_HOME = "app.home";
    private static final ClassLoader PARENT_CLASS_LOADER;
    private final ClassLoader classLoader;

    JavaExecutor(Set<String> filePaths) {
        logger.info("Creating java classloader with [" + filePaths.size() + "] dependencies [" + filePaths + "]");
        if (!filePaths.isEmpty()) {
            HashSet result = Sets.newHashSet();
            for (String filePath : filePaths) {
                try {
                    result.add(new File(filePath).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    logger.error("Failed to add to the classloader path [" + filePath + "]", (Throwable)e);
                }
            }
            this.classLoader = new URLClassLoader(result.toArray(new URL[result.size()]), PARENT_CLASS_LOADER);
        } else {
            this.classLoader = this.getClass().getClassLoader();
        }
    }

    public static ClassLoader getParentClassLoader() {
        return PARENT_CLASS_LOADER;
    }

    Object execute(String className, String methodName, JavaExecutionParametersProvider parametersProvider) {
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Class actionClass = this.getActionClass(className);
            Method executionMethod = this.getMethodByName(actionClass, methodName);
            Object[] executionParameters = parametersProvider.getExecutionParameters(executionMethod);
            Object[] transformedExecutionParameters = this.transformExecutionParameters(executionParameters, executionMethod);
            Object object = executionMethod.invoke(actionClass.newInstance(), transformedExecutionParameters);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("Method [" + methodName + "] invocation of class [" + className + "] failed: " + e.getMessage(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
        }
    }

    private Object[] transformExecutionParameters(Object[] oldExecutionParameters, Method executionMethod) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException {
        Object[] transformedExecutionParameters = new Object[oldExecutionParameters.length];
        String stringClassCanonicalName = String.class.getCanonicalName();
        for (int i = 0; i < oldExecutionParameters.length; ++i) {
            Object currentParameter = oldExecutionParameters[i];
            if (currentParameter != null) {
                Class<?> currentParameterClass = currentParameter.getClass();
                Class<?> expectedClass = executionMethod.getParameterTypes()[i];
                if (!currentParameterClass.getCanonicalName().equals(stringClassCanonicalName)) {
                    if (this.isSerializableSessionObjectMismatch(expectedClass, currentParameterClass)) {
                        String valueFieldName = "value";
                        String nameFieldName = "name";
                        Object valueField = this.getFieldValue(valueFieldName, currentParameterClass, currentParameter);
                        Object nameField = this.getFieldValueFromSuperClass(nameFieldName, currentParameterClass, currentParameter);
                        Object transformedParameter = expectedClass.newInstance();
                        this.setValue(valueField, expectedClass, transformedParameter);
                        this.setName(nameField, expectedClass, transformedParameter);
                        transformedExecutionParameters[i] = transformedParameter;
                        continue;
                    }
                    transformedExecutionParameters[i] = currentParameter;
                    continue;
                }
                transformedExecutionParameters[i] = currentParameter;
                continue;
            }
            transformedExecutionParameters[i] = null;
        }
        return transformedExecutionParameters;
    }

    private Object getFieldValue(String fieldName, Class<?> currentParameterClass, Object currentParameter) throws NoSuchFieldException, IllegalAccessException {
        Field field = currentParameterClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(currentParameter);
    }

    private Object getFieldValueFromSuperClass(String fieldName, Class<?> currentParameterClass, Object currentParameter) throws NoSuchFieldException, IllegalAccessException {
        Class<?> superClass = currentParameterClass.getSuperclass();
        return this.getFieldValue(fieldName, superClass, currentParameter);
    }

    private void setValue(Object value, Class<?> currentParameterClass, Object currentParameter) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        this.setField("Value", value, Serializable.class, currentParameterClass, currentParameter);
    }

    private void setName(Object name, Class<?> currentParameterClass, Object currentParameter) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        this.setField("Name", name, String.class, currentParameterClass, currentParameter);
    }

    private void setField(String fieldId, Object fieldValue, Class<?> fieldType, Class<?> currentParameterClass, Object currentParameter) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method setterMethod = currentParameterClass.getMethod("set" + fieldId, fieldType);
        setterMethod.invoke(currentParameter, fieldValue);
    }

    private boolean isSerializableSessionObjectMismatch(Class<?> expectedClass, Class<?> currentParameterClass) {
        return "com.hp.oo.sdk.content.plugin.SerializableSessionObject".equals(currentParameterClass.getCanonicalName()) && expectedClass != currentParameterClass;
    }

    private Class getActionClass(String className) {
        Class<?> actionClass;
        try {
            actionClass = Class.forName(className, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class name " + className + " was not found", e);
        }
        return actionClass;
    }

    private Method getMethodByName(Class actionClass, String methodName) {
        Method[] methods = actionClass.getDeclaredMethods();
        Method actionMethod = null;
        for (Method m : methods) {
            if (!m.getName().equals(methodName)) continue;
            actionMethod = m;
        }
        return actionMethod;
    }

    @Override
    public void allocate() {
    }

    @Override
    public void release() {
    }

    @Override
    public void close() {
    }

    static {
        ClassLoader parentClassLoader = JavaExecutor.class.getClassLoader();
        while (parentClassLoader.getParent() != null) {
            parentClassLoader = parentClassLoader.getParent();
        }
        URL[] parentUrls = new URL[]{};
        try {
            Collection foundFiles;
            String appHomeDir = System.getProperty(APP_HOME);
            File appLibDir = new File(appHomeDir, "lib");
            if (appLibDir.exists() && appLibDir.isDirectory() && (foundFiles = FileUtils.listFiles((File)appLibDir, (IOFileFilter)new WildcardFileFilter(SCORE_CONTENT_SDK_JAR), (IOFileFilter)DirectoryFileFilter.DIRECTORY)) != null && !foundFiles.isEmpty()) {
                for (File file : foundFiles) {
                    parentUrls = new URL[]{file.toURI().toURL()};
                }
            }
        }
        catch (MalformedURLException e) {
            logger.error("Failed to build classpath for parent classloader", (Throwable)e);
        }
        PARENT_CLASS_LOADER = new URLClassLoader(parentUrls, parentClassLoader);
    }
}

