/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python;

import io.cloudslang.runtime.api.python.PythonEvaluationResult;
import io.cloudslang.runtime.api.python.PythonExecutionResult;
import io.cloudslang.runtime.impl.python.PythonExecutor;
import io.cloudslang.runtime.impl.python.security.BoundedStringWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyClass;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFunction;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyReflectedFunction;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyType;
import org.python.util.PythonInterpreter;

public class EmbeddedPythonExecutorWrapper {
    private static final Logger logger = LogManager.getLogger(PythonExecutor.class);
    private static final int retriesForNoModuleFound = 3;
    private static final int exceptionMaxLength = Integer.getInteger("input.error.max.length", 1000);
    private static final Supplier<RuntimeException> outputStreamLengthExceededSupplier = () -> new IllegalStateException("Cannot exceed threshold for python standard output stream.");
    private static final Supplier<RuntimeException> errorStreamLengthExceededSupplier = () -> new IllegalStateException("Cannot exceed threshold for python standard error stream.");
    private static final String noModuleNamedIssue = "No module named";
    private final PythonInterpreter pythonInterpreter;
    private final AtomicBoolean closed;

    public EmbeddedPythonExecutorWrapper() {
        this(Collections.emptySet());
    }

    public EmbeddedPythonExecutorWrapper(Set<String> dependencies) {
        this.pythonInterpreter = new PythonInterpreter(null, this.getPySystemState(dependencies));
        this.closed = new AtomicBoolean(false);
        this.initialize();
    }

    private void initialize() {
        try {
            this.pythonInterpreter.exec("import io");
        }
        catch (Exception initException) {
            logger.error("Could not initialize python interpreter: ", (Throwable)initException);
        }
    }

    public PythonExecutionResult exec(String script, Map<String, Serializable> callArguments) {
        this.validateInterpreter();
        BoundedStringWriter outputWriter = new BoundedStringWriter(outputStreamLengthExceededSupplier);
        BoundedStringWriter errorWriter = new BoundedStringWriter(errorStreamLengthExceededSupplier);
        try {
            this.pythonInterpreter.setOut((Writer)outputWriter);
            this.pythonInterpreter.setErr((Writer)errorWriter);
            this.pythonInterpreter.setIn((InputStream)new NullInputStream(0L));
            this.prepareInterpreterContext(callArguments);
            Exception originalExc = null;
            for (int i = 0; i < 3; ++i) {
                try {
                    PythonExecutionResult pythonExecutionResult = this.doExec(script);
                    return pythonExecutionResult;
                }
                catch (Exception exc) {
                    if (!this.isNoModuleFoundIssue(exc)) {
                        throw new RuntimeException("Error executing python script: " + exc, exc);
                    }
                    if (originalExc != null) continue;
                    originalExc = exc;
                    continue;
                }
            }
            throw new RuntimeException("Error executing python script: " + originalExc, originalExc);
        }
        finally {
            String standardStreamError;
            String standardStreamOutput = ((Object)outputWriter).toString();
            if (StringUtils.isNotEmpty((CharSequence)standardStreamOutput)) {
                logger.info("Script output: " + standardStreamOutput);
            }
            if (StringUtils.isNotEmpty((CharSequence)(standardStreamError = ((Object)errorWriter).toString()))) {
                logger.error("Script error: " + standardStreamError);
            }
        }
    }

    public PythonEvaluationResult eval(String prepareEnvironmentScript, String expr, Map<String, Serializable> context) {
        this.validateInterpreter();
        try {
            this.pythonInterpreter.setOut((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            this.pythonInterpreter.setErr((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            this.pythonInterpreter.setIn((InputStream)new NullInputStream(0L));
            this.prepareInterpreterContext(context);
            Serializable eval = this.doEval(prepareEnvironmentScript, expr);
            return new PythonEvaluationResult(eval, this.getPythonLocals());
        }
        catch (PyException exception) {
            throw new RuntimeException("Error in running script expression: '" + this.getTruncatedExpression(expr) + "',\n\tException is: " + this.handleExceptionSpecialCases(exception.value.toString()), exception);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error in running script expression: '" + this.getTruncatedExpression(expr) + "',\n\tException is: " + this.handleExceptionSpecialCases(exception.getMessage()), exception);
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.pythonInterpreter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int getMapCapacity(int expectedSize) {
        return expectedSize < 3 ? expectedSize + 1 : (expectedSize < 0x40000000 ? expectedSize + expectedSize / 3 : Integer.MAX_VALUE);
    }

    private void prepareInterpreterContext(Map<String, Serializable> context) {
        this.pythonInterpreter.setLocals((PyObject)new PyStringMap(this.getMapCapacity(context.size())));
        for (Map.Entry<String, Serializable> entry : context.entrySet()) {
            this.pythonInterpreter.set(entry.getKey(), (Object)entry.getValue());
        }
    }

    private PythonExecutionResult doExec(String script) {
        this.pythonInterpreter.exec(script);
        return this.processExecResults();
    }

    private boolean isNoModuleFoundIssue(Exception e) {
        if (e instanceof PyException) {
            PyException pyException = (PyException)((Object)e);
            String message = pyException.value.toString();
            return message.contains(noModuleNamedIssue);
        }
        return false;
    }

    private PythonExecutionResult processExecResults() {
        Iterator localsIterator = this.pythonInterpreter.getLocals().asIterable().iterator();
        HashMap<String, Serializable> returnValue = new HashMap<String, Serializable>();
        while (localsIterator.hasNext()) {
            PyObject value;
            PyObject next = (PyObject)localsIterator.next();
            String key = next.asString();
            if (this.isLocalEntryExcluded(key, value = this.pythonInterpreter.get(key))) continue;
            returnValue.put(key, this.resolveJythonObjectToJavaForExec(value, key));
        }
        return new PythonExecutionResult(returnValue);
    }

    private Serializable resolveJythonObjectToJavaForExec(PyObject value, String key) {
        String errorMessage = "Non-serializable values are not allowed in the output context of a Python script:\n\tConversion failed for '" + key + "' (" + value + "),\n\tThe error can be solved by removing the variable from the context in the script: e.g. 'del " + key + "'.\n";
        return this.resolveJythonObjectToJava(value, errorMessage);
    }

    private Serializable resolveJythonObjectToJavaForEval(PyObject value, String expression) {
        String errorMessage = "Evaluation result for a Python expression should be serializable:\n\tConversion failed for '" + expression + "' (" + value + ").\n";
        return this.resolveJythonObjectToJava(value, errorMessage);
    }

    private Serializable resolveJythonObjectToJava(PyObject value, String errorMessage) {
        if (value == null) {
            return null;
        }
        if (value instanceof PyBoolean) {
            PyBoolean pyBoolean = (PyBoolean)value;
            return Boolean.valueOf(pyBoolean.getBooleanValue());
        }
        try {
            return (Serializable)Py.tojava((PyObject)value, Serializable.class);
        }
        catch (PyException pyException) {
            PyType type;
            String typeName;
            PyObject typeObject = pyException.type;
            if (typeObject instanceof PyType && "TypeError".equals(typeName = (type = (PyType)typeObject).getName())) {
                throw new RuntimeException(errorMessage, pyException);
            }
            throw pyException;
        }
    }

    private boolean isLocalEntryExcluded(String key, PyObject value) {
        return key.startsWith("__") && key.endsWith("__") || value instanceof PyFile || value instanceof PyModule || value instanceof PyFunction || value instanceof PySystemState || value instanceof PyClass || value instanceof PyType || value instanceof PyReflectedFunction;
    }

    private Map<String, Serializable> getPythonLocals() {
        HashMap<String, Serializable> retVal = new HashMap<String, Serializable>();
        for (PyObject pyObject : this.pythonInterpreter.getLocals().asIterable()) {
            PyObject value;
            String key = pyObject.asString();
            if (this.isLocalEntryExcluded(key, value = this.pythonInterpreter.get(key))) continue;
            retVal.put(key, (Serializable)value);
        }
        return retVal;
    }

    private String getTruncatedExpression(String expr) {
        return expr.length() > exceptionMaxLength ? expr.substring(0, exceptionMaxLength) + "..." : expr;
    }

    private String handleExceptionSpecialCases(String message) {
        String processedMessage = message;
        if (StringUtils.isNotEmpty((CharSequence)message) && message.contains("get_sp") && message.contains("not defined")) {
            processedMessage = message + ". Make sure to use correct syntax for the function: get_sp('fully.qualified.name', optional_default_value).";
        }
        return processedMessage;
    }

    private void validateInterpreter() {
        if (this.closed.get()) {
            throw new RuntimeException("Trying to execute Python code on an already closed interpreter");
        }
    }

    private Serializable doEval(String prepareEnvironmentScript, String script) {
        this.pythonInterpreter.set("true", (Object)Boolean.TRUE);
        this.pythonInterpreter.set("false", (Object)Boolean.FALSE);
        if (StringUtils.isNotEmpty((CharSequence)prepareEnvironmentScript)) {
            this.pythonInterpreter.exec(prepareEnvironmentScript);
        }
        PyObject evalResultPyObject = this.pythonInterpreter.eval(script);
        return this.resolveJythonObjectToJavaForEval(evalResultPyObject, script);
    }

    private PySystemState getPySystemState(Set<String> dependencies) {
        PySystemState pySystemState = new PySystemState();
        if (!dependencies.isEmpty()) {
            for (String dependency : dependencies) {
                pySystemState.path.append((PyObject)new PyString(dependency));
            }
        }
        return pySystemState;
    }
}

