/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python;

import io.cloudslang.dependency.impl.services.DependenciesManagementConfiguration;
import io.cloudslang.runtime.api.python.PythonRuntimeService;
import io.cloudslang.runtime.impl.python.PythonExecutionCachedEngine;
import io.cloudslang.runtime.impl.python.PythonExecutionEngine;
import io.cloudslang.runtime.impl.python.PythonExecutionNotCachedEngine;
import io.cloudslang.runtime.impl.python.PythonExecutionPooledAndCachedEngine;
import io.cloudslang.runtime.impl.python.PythonRuntimeServiceImpl;
import io.cloudslang.runtime.impl.python.external.ExternalPythonExecutionEngine;
import io.cloudslang.runtime.impl.python.external.ExternalPythonExecutorServiceImpl;
import io.cloudslang.runtime.impl.python.external.ExternalPythonRuntimeServiceImpl;
import io.cloudslang.runtime.impl.python.external.StatefulRestEasyClientsHolder;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ComponentScan(value={"io.cloudslang.runtime.impl.python"})
@Import(value={DependenciesManagementConfiguration.class})
public class PythonExecutionEngineConfiguration {
    @Bean(name={"jythonRuntimeService"})
    public PythonRuntimeService pythonRuntimeService() {
        return new PythonRuntimeServiceImpl();
    }

    @Bean(name={"externalPythonRuntimeService"})
    public PythonRuntimeService externalPythonRuntimeService() {
        Integer pythonProcessPermits = Integer.getInteger("python.concurrent.execution.permits", 30);
        Integer pythonTestingProcessPermits = Integer.getInteger("python.testing.concurrent.execution.permits", 10);
        return new ExternalPythonRuntimeServiceImpl(new Semaphore(pythonProcessPermits), new Semaphore(pythonTestingProcessPermits));
    }

    @Bean(name={"externalPythonExecutorService"})
    public PythonRuntimeService externalPythonExecutorService(StatefulRestEasyClientsHolder statefulRestEasyClient) {
        Integer pythonProcessPermits = Integer.getInteger("python.concurrent.execution.permits", 30);
        Integer pythonTestingProcessPermits = Integer.getInteger("python.testing.concurrent.execution.permits", 10);
        return new ExternalPythonExecutorServiceImpl(statefulRestEasyClient, new Semaphore(pythonProcessPermits), new Semaphore(pythonTestingProcessPermits));
    }

    @Bean(name={"jythonExecutionEngine"})
    PythonExecutionEngine pythonExecutionEngine() {
        String pooledAndCachedEngine = PythonExecutionPooledAndCachedEngine.class.getSimpleName();
        String cacheEngine = PythonExecutionCachedEngine.class.getSimpleName();
        String simpleEngine = PythonExecutionNotCachedEngine.class.getSimpleName();
        String value = System.getProperty("python.executor.engine", pooledAndCachedEngine);
        if (StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)pooledAndCachedEngine)) {
            return new PythonExecutionPooledAndCachedEngine();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)cacheEngine)) {
            return new PythonExecutionCachedEngine();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)simpleEngine)) {
            return new PythonExecutionNotCachedEngine();
        }
        return new PythonExecutionPooledAndCachedEngine();
    }

    @Bean(name={"externalPythonExecutionEngine"})
    PythonExecutionEngine externalPythonExecutionEngine() {
        return new ExternalPythonExecutionEngine();
    }
}

