/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.cloudslang.dependency.api.services.DependencyService;
import io.cloudslang.runtime.api.python.PythonEvaluationResult;
import io.cloudslang.runtime.api.python.PythonExecutionResult;
import io.cloudslang.runtime.api.python.enums.PythonStrategy;
import io.cloudslang.runtime.impl.ExecutionEngine;
import io.cloudslang.runtime.impl.python.EmbeddedPythonExecutorWrapper;
import io.cloudslang.runtime.impl.python.PythonExecutionEngine;
import io.cloudslang.runtime.impl.python.pool.ViburEmbeddedPythonPoolService;
import io.cloudslang.runtime.impl.python.pool.ViburEmbeddedPythonPoolServiceImpl;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.vibur.objectpool.util.ConcurrentLinkedQueueCollection;

public class PythonExecutionPooledAndCachedEngine
extends ExecutionEngine
implements PythonExecutionEngine {
    @Autowired
    private DependencyService dependencyService;
    @Autowired
    @Qualifier(value="numberOfExecutionThreads")
    private Integer numberOfThreads;
    private ViburEmbeddedPythonPoolService pythonExecutorPool;
    private Cache<String, EmbeddedPythonExecutorWrapper> cachedExecutors;

    @PostConstruct
    public void init() {
        this.cachedExecutors = Caffeine.newBuilder().maximumSize((long)Integer.getInteger("jython.executor.cacheSize", this.numberOfThreads * 4 / 3).intValue()).build();
        this.doSetPythonExecutorPool();
    }

    private void doSetPythonExecutorPool() {
        boolean useExternalPython = PythonStrategy.getPythonStrategy((String)System.getProperty("python.expressionsEval"), (PythonStrategy)PythonStrategy.PYTHON_EXECUTOR) != PythonStrategy.JYTHON;
        int defaultPoolSize = useExternalPython ? Math.max(2, this.numberOfThreads / 4) : Math.max(2, this.numberOfThreads * 3 / 4);
        int maxPoolSize = Integer.getInteger("jython.executor.maxPoolSize", defaultPoolSize);
        if (maxPoolSize > 100) {
            maxPoolSize = 100;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors()));
        ConcurrentLinkedQueueCollection collection = new ConcurrentLinkedQueueCollection();
        for (int i = 0; i < maxPoolSize; ++i) {
            executorService.submit(() -> {
                try {
                    collection.offerLast((Object)new EmbeddedPythonExecutorWrapper());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        try {
            executorService.shutdown();
            executorService.awaitTermination(7L, TimeUnit.MINUTES);
            executorService.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (collection.size() < maxPoolSize) {
            collection.offerLast((Object)new EmbeddedPythonExecutorWrapper());
        }
        this.pythonExecutorPool = new ViburEmbeddedPythonPoolServiceImpl((ConcurrentLinkedQueueCollection<EmbeddedPythonExecutorWrapper>)collection, maxPoolSize, maxPoolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PythonExecutionResult exec(Set<String> dependencies, String script, Map<String, Serializable> vars) {
        Set resultedDependencies = this.dependencyService.getDependencies(dependencies);
        if (resultedDependencies.isEmpty()) {
            EmbeddedPythonExecutorWrapper pooledPythonExecutor = null;
            try {
                pooledPythonExecutor = this.pythonExecutorPool.tryTakeWithTimeout();
                PythonExecutionResult pythonExecutionResult = pooledPythonExecutor.exec(script, vars);
                return pythonExecutionResult;
            }
            finally {
                this.doRestoreExecutor(pooledPythonExecutor);
            }
        }
        String dependenciesKey = this.generatedDependenciesKey(dependencies);
        EmbeddedPythonExecutorWrapper executor = (EmbeddedPythonExecutorWrapper)this.cachedExecutors.getIfPresent((Object)dependenciesKey);
        if (executor == null) {
            EmbeddedPythonExecutorWrapper newPythonExecutor = new EmbeddedPythonExecutorWrapper(resultedDependencies);
            executor = (EmbeddedPythonExecutorWrapper)this.cachedExecutors.get((Object)dependenciesKey, k -> newPythonExecutor);
        }
        return executor.exec(script, vars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PythonEvaluationResult eval(String prepareEnvironmentScript, String script, Map<String, Serializable> vars) {
        EmbeddedPythonExecutorWrapper embeddedPythonExecutor = null;
        try {
            embeddedPythonExecutor = this.pythonExecutorPool.tryTakeWithTimeout();
            PythonEvaluationResult pythonEvaluationResult = embeddedPythonExecutor.eval(prepareEnvironmentScript, script, vars);
            return pythonEvaluationResult;
        }
        finally {
            this.doRestoreExecutor(embeddedPythonExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PythonEvaluationResult test(String prepareEnvironmentScript, String script, Map<String, Serializable> vars, long timeout) {
        EmbeddedPythonExecutorWrapper embeddedPythonExecutor = null;
        try {
            embeddedPythonExecutor = this.pythonExecutorPool.tryTakeWithTimeout();
            PythonEvaluationResult pythonEvaluationResult = embeddedPythonExecutor.eval(prepareEnvironmentScript, script, vars);
            return pythonEvaluationResult;
        }
        finally {
            this.doRestoreExecutor(embeddedPythonExecutor);
        }
    }

    private void doRestoreExecutor(EmbeddedPythonExecutorWrapper pooledPythonExecutor) {
        try {
            this.pythonExecutorPool.restore(pooledPythonExecutor);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @PreDestroy
    public void closeResources() {
        this.pythonExecutorPool.close();
        try {
            this.cachedExecutors.asMap().values().forEach(EmbeddedPythonExecutorWrapper::close);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

