/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python.external;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.cloudslang.runtime.api.python.ExternalPythonProcessRunService;
import io.cloudslang.runtime.api.python.PythonEvaluationResult;
import io.cloudslang.runtime.api.python.PythonExecutionResult;
import io.cloudslang.runtime.impl.python.external.EvaluationResults;
import io.cloudslang.runtime.impl.python.external.ExternalPythonEvalException;
import io.cloudslang.runtime.impl.python.external.ExternalPythonScriptException;
import io.cloudslang.runtime.impl.python.external.ExternalPythonTestRunnable;
import io.cloudslang.runtime.impl.python.external.ExternalPythonTimeoutRunnable;
import io.cloudslang.runtime.impl.python.external.ResourceScriptResolver;
import io.cloudslang.runtime.impl.python.external.ScriptResults;
import io.cloudslang.runtime.impl.python.external.model.TempEnvironment;
import io.cloudslang.runtime.impl.python.external.model.TempExecutionEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExternalPythonExecutorScheduledExecutorTimeout
implements ExternalPythonProcessRunService {
    private static final Logger logger = LogManager.getLogger(ExternalPythonExecutorScheduledExecutorTimeout.class);
    private static final String PYTHON_SCRIPT_FILENAME = "script";
    private static final String EVAL_PY = "eval.py";
    private static final String MAIN_PY = "main.py";
    private static final String PYTHON_SUFFIX = ".py";
    private static final long EXECUTION_TIMEOUT = Long.getLong("python.timeout", 30L) * 60L * 1000L;
    private static final long EVALUATION_TIMEOUT = Long.getLong("python.evaluation.timeout", 3L) * 60L * 1000L;
    private static final String PYTHON_FILENAME_SCRIPT_EXTENSION = ".py\"";
    private static final int PYTHON_FILENAME_DELIMITERS = 6;
    private static final ObjectMapper objectMapper;
    private static final ScheduledThreadPoolExecutor timeoutScheduledExecutor;
    private static final ThreadFactory testThreadFactory;

    public PythonExecutionResult exec(String script, Map<String, Serializable> inputs) {
        PythonExecutionResult pythonExecutionResult;
        TempEnvironment tempExecutionEnvironment = null;
        try {
            String pythonPath = this.checkPythonPath();
            tempExecutionEnvironment = this.generateTempResourcesForExec(script);
            String payload = this.generatePayloadForExec(((TempExecutionEnvironment)tempExecutionEnvironment).getUserScriptName(), inputs);
            this.addFilePermissions(tempExecutionEnvironment.getParentFolder());
            pythonExecutionResult = this.runPythonExecutionProcess(pythonPath, payload, (TempExecutionEnvironment)tempExecutionEnvironment);
        }
        catch (IOException e) {
            try {
                String message = "Failed to generate execution resources";
                logger.error(message, (Throwable)e);
                throw new RuntimeException(message);
            }
            catch (Throwable throwable) {
                if (tempExecutionEnvironment != null && !FileUtils.deleteQuietly((File)tempExecutionEnvironment.getParentFolder())) {
                    logger.warn(String.format("Failed to cleanup python execution resources {%s}", tempExecutionEnvironment.getParentFolder()));
                }
                throw throwable;
            }
        }
        if (tempExecutionEnvironment != null && !FileUtils.deleteQuietly((File)tempExecutionEnvironment.getParentFolder())) {
            logger.warn(String.format("Failed to cleanup python execution resources {%s}", tempExecutionEnvironment.getParentFolder()));
        }
        return pythonExecutionResult;
    }

    public PythonEvaluationResult eval(String expression, String prepareEnvironmentScript, Map<String, Serializable> context) {
        return this.getPythonEvaluationResult(expression, prepareEnvironmentScript, context);
    }

    public PythonEvaluationResult test(String expression, String prepareEnvironmentScript, Map<String, Serializable> context, long timeout) {
        return this.getPythonTestResult(expression, prepareEnvironmentScript, context, timeout);
    }

    private PythonEvaluationResult getPythonTestResult(String expression, String prepareEnvironmentScript, Map<String, Serializable> context, long evaluationTimeout) {
        try {
            String pythonPath = this.checkPythonPath();
            String payload = this.generatePayloadForEval(expression, prepareEnvironmentScript, context);
            return this.runPythonTestProcess(pythonPath, payload, context, evaluationTimeout);
        }
        catch (IOException e) {
            String message = "Failed to test Python expression";
            logger.error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
    }

    private PythonEvaluationResult getPythonEvaluationResult(String expression, String prepareEnvironmentScript, Map<String, Serializable> context) {
        try {
            String pythonPath = this.checkPythonPath();
            String payload = this.generatePayloadForEval(expression, prepareEnvironmentScript, context);
            return this.runPythonEvalProcess(pythonPath, payload, context, EVALUATION_TIMEOUT);
        }
        catch (IOException e) {
            String message = "Failed to evaluate Python expression";
            logger.error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
    }

    private void addFilePermissions(File file) throws IOException {
        HashSet<PosixFilePermission> filePermissions = new HashSet<PosixFilePermission>();
        filePermissions.add(PosixFilePermission.OWNER_READ);
        File[] fileChildren = file.listFiles();
        if (fileChildren != null) {
            for (File child : fileChildren) {
                if (SystemUtils.IS_OS_WINDOWS) {
                    child.setReadOnly();
                    continue;
                }
                Files.setPosixFilePermissions(child.toPath(), filePermissions);
            }
        }
    }

    private String checkPythonPath() {
        String pythonPath = System.getProperty("python.path");
        if (StringUtils.isEmpty((String)pythonPath) || !new File(pythonPath).exists()) {
            throw new IllegalArgumentException("Missing or invalid python path");
        }
        return pythonPath;
    }

    private Document parseScriptExecutionResult(String scriptExecutionResult) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(scriptExecutionResult));
        return db.parse(is);
    }

    private PythonExecutionResult runPythonExecutionProcess(String pythonPath, String payload, TempExecutionEnvironment executionEnvironment) {
        ProcessBuilder processBuilder = this.preparePythonProcess(executionEnvironment, pythonPath);
        try {
            String returnResult = this.getResult(payload, processBuilder, EXECUTION_TIMEOUT);
            returnResult = this.parseScriptExecutionResult(returnResult).getElementsByTagName("result").item(0).getTextContent();
            ScriptResults scriptResults = (ScriptResults)objectMapper.readValue(returnResult, ScriptResults.class);
            String exception = this.formatException(scriptResults.getException(), scriptResults.getTraceback());
            if (!StringUtils.isEmpty((String)exception)) {
                logger.error(String.format("Failed to execute script {%s}", exception));
                throw new ExternalPythonScriptException(String.format("Failed to execute user script: %s", exception));
            }
            return new PythonExecutionResult(scriptResults.getReturnResult());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.error("Failed to run script. ", e.getCause() != null ? e.getCause() : e);
            throw new RuntimeException("Failed to run script.");
        }
    }

    private PythonEvaluationResult runPythonEvalProcess(String pythonPath, String payload, Map<String, Serializable> context, long timeout) {
        ProcessBuilder processBuilder = this.preparePythonProcessForEval(pythonPath, ResourceScriptResolver.loadEvalScriptAsString());
        try {
            String returnResult = this.getResult(payload, processBuilder, timeout);
            EvaluationResults scriptResults = (EvaluationResults)objectMapper.readValue(returnResult, EvaluationResults.class);
            String exception = scriptResults.getException();
            if (!StringUtils.isEmpty((String)exception)) {
                logger.error(String.format("Failed to execute script {%s}", exception));
                throw new ExternalPythonEvalException(exception);
            }
            context.put("accessed_resources_set", (Serializable)((Object)scriptResults.getAccessedResources()));
            return new PythonEvaluationResult(this.processReturnResult(scriptResults), context);
        }
        catch (IOException ioException) {
            logger.error("Failed to run script. ", ioException.getCause() != null ? ioException.getCause() : ioException);
            throw new RuntimeException("Failed to run script.");
        }
    }

    private PythonEvaluationResult runPythonTestProcess(String pythonPath, String payload, Map<String, Serializable> context, long timeout) {
        ProcessBuilder processBuilder = this.preparePythonProcessForEval(pythonPath, ResourceScriptResolver.loadEvalScriptAsString());
        try {
            ExternalPythonTestRunnable testRunnable = new ExternalPythonTestRunnable(processBuilder, payload);
            Thread threadTest = testThreadFactory.newThread(testRunnable);
            threadTest.start();
            threadTest.join(timeout);
            if (threadTest.isAlive()) {
                testRunnable.destroyProcess();
                throw new RuntimeException("Python timeout of " + timeout + " millis has been reached");
            }
            RuntimeException scriptExc = testRunnable.getException();
            if (scriptExc != null) {
                throw scriptExc;
            }
            String returnResult = testRunnable.getResult();
            EvaluationResults scriptResults = (EvaluationResults)objectMapper.readValue(returnResult, EvaluationResults.class);
            String exception = scriptResults.getException();
            if (!StringUtils.isEmpty((String)exception)) {
                logger.error(String.format("Failed to execute script {%s}", exception));
                throw new ExternalPythonEvalException(exception);
            }
            context.put("accessed_resources_set", (Serializable)((Object)scriptResults.getAccessedResources()));
            return new PythonEvaluationResult(this.processReturnResult(scriptResults), context);
        }
        catch (IOException | InterruptedException e) {
            logger.error("Failed to run script. ", e.getCause() != null ? e.getCause() : e);
            throw new RuntimeException("Failed to run script.");
        }
    }

    private Serializable processReturnResult(EvaluationResults results) throws JsonProcessingException {
        EvaluationResults.ReturnType returnType = results.getReturnType();
        if (returnType == null) {
            throw new RuntimeException("Missing return type for return result.");
        }
        switch (returnType) {
            case BOOLEAN: {
                return Boolean.valueOf(results.getReturnResult());
            }
            case INTEGER: {
                return new BigInteger(results.getReturnResult());
            }
            case LIST: {
                return (Serializable)objectMapper.readValue(results.getReturnResult(), (TypeReference)new TypeReference<ArrayList<Serializable>>(){});
            }
        }
        return results.getReturnResult();
    }

    private String getResult(String payload, ProcessBuilder processBuilder, long timeoutPeriodMillis) {
        ScheduledFuture<?> scheduledFuture = null;
        MutableBoolean wasProcessDestroyed = new MutableBoolean(false);
        try {
            String line;
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            ExternalPythonTimeoutRunnable runnable = new ExternalPythonTimeoutRunnable(wasProcessDestroyed, process);
            scheduledFuture = timeoutScheduledExecutor.schedule(runnable, timeoutPeriodMillis, TimeUnit.MILLISECONDS);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8));
            printWriter.println(payload);
            printWriter.flush();
            IOException readExc = null;
            StringBuilder returnResult = new StringBuilder();
            try {
                while ((line = reader.readLine()) != null) {
                    returnResult.append(line);
                }
            }
            catch (IOException exc) {
                if (wasProcessDestroyed.isTrue()) {
                    throw new RuntimeException("Python timeout of " + timeoutPeriodMillis + " millis has been reached");
                }
                readExc = exc;
            }
            process.waitFor();
            if (wasProcessDestroyed.isTrue() || readExc != null) {
                if (wasProcessDestroyed.isTrue()) {
                    throw new RuntimeException("Python timeout of " + timeoutPeriodMillis + " millis has been reached");
                }
                throw new RuntimeException("Script execution failed: ", readExc);
            }
            while ((line = reader.readLine()) != null) {
                returnResult.append(line);
            }
            String string = returnResult.toString();
            return string;
        }
        catch (IOException exception) {
            throw new RuntimeException("Script execution failed: ", exception);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
        }
    }

    private ProcessBuilder preparePythonProcess(TempEnvironment executionEnvironment, String pythonPath) {
        ProcessBuilder processBuilder = new ProcessBuilder(Arrays.asList(Paths.get(pythonPath, "python").toString(), Paths.get(executionEnvironment.getParentFolder().toString(), executionEnvironment.getMainScriptName()).toString()));
        processBuilder.environment().clear();
        processBuilder.directory(executionEnvironment.getParentFolder());
        return processBuilder;
    }

    private ProcessBuilder preparePythonProcessForEval(String pythonPath, String evalPyCode) {
        ProcessBuilder processBuilder = new ProcessBuilder(Arrays.asList(Paths.get(pythonPath, "python").toString(), "-c", evalPyCode));
        processBuilder.environment().clear();
        return processBuilder;
    }

    private TempExecutionEnvironment generateTempResourcesForExec(String script) throws IOException {
        Path execTempDirectory = Files.createTempDirectory("python_execution", new FileAttribute[0]);
        File tempUserScript = File.createTempFile(PYTHON_SCRIPT_FILENAME, PYTHON_SUFFIX, execTempDirectory.toFile());
        FileUtils.writeStringToFile((File)tempUserScript, (String)script, (Charset)StandardCharsets.UTF_8);
        File mainScriptFile = new File(execTempDirectory.toString(), MAIN_PY);
        FileUtils.writeByteArrayToFile((File)mainScriptFile, (byte[])ResourceScriptResolver.loadExecScriptAsBytes());
        String tempUserScriptName = FilenameUtils.getName((String)tempUserScript.toString());
        return new TempExecutionEnvironment(tempUserScriptName, MAIN_PY, execTempDirectory.toFile());
    }

    private String generatePayloadForEval(String expression, String prepareEnvironmentScript, Map<String, Serializable> context) throws JsonProcessingException {
        HashMap<String, Object> payload = new HashMap<String, Object>(4);
        payload.put("expression", expression);
        payload.put("envSetup", prepareEnvironmentScript);
        payload.put("context", (Serializable)((Object)context));
        return objectMapper.writeValueAsString(payload);
    }

    private String generatePayloadForExec(String userScript, Map<String, Serializable> inputs) throws JsonProcessingException {
        HashMap<String, String> parsedInputs = new HashMap<String, String>();
        for (Map.Entry<String, Serializable> entry : inputs.entrySet()) {
            parsedInputs.put(entry.getKey(), entry.getValue().toString());
        }
        HashMap<String, Object> payload = new HashMap<String, Object>(3);
        payload.put("script_name", FilenameUtils.removeExtension((String)userScript));
        payload.put("inputs", parsedInputs);
        return objectMapper.writeValueAsString(payload);
    }

    private String formatException(String exception, List<String> traceback) {
        return CollectionUtils.isEmpty(traceback) ? exception : this.removeFileName(traceback.get(traceback.size() - 1)) + ", " + exception;
    }

    private String removeFileName(String trace) {
        int pythonFileNameIndex = trace.indexOf(PYTHON_FILENAME_SCRIPT_EXTENSION);
        return trace.substring(pythonFileNameIndex + 6);
    }

    public String getStrategyName() {
        return "scheduled-executor";
    }

    static {
        JsonFactory factory = new JsonFactory();
        factory.enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
        factory.enable(JsonWriteFeature.ESCAPE_NON_ASCII.mappedFeature());
        objectMapper = new ObjectMapper(factory);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("python-timeout-%d").setDaemon(true).build();
        int nrThreads = Integer.getInteger("python.timeout.threadCount", 1);
        ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(nrThreads, threadFactory);
        scheduledExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        scheduledExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        scheduledExecutor.setRemoveOnCancelPolicy(true);
        scheduledExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        timeoutScheduledExecutor = scheduledExecutor;
        testThreadFactory = new ThreadFactoryBuilder().setNameFormat("python-test-%d").setDaemon(true).build();
    }
}

