/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python.external;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudslang.runtime.api.python.PythonEvaluationResult;
import io.cloudslang.runtime.api.python.PythonExecutionResult;
import io.cloudslang.runtime.api.python.PythonRuntimeService;
import io.cloudslang.runtime.impl.python.external.EvaluationResults;
import io.cloudslang.runtime.impl.python.external.ExternalPythonEvalException;
import io.cloudslang.runtime.impl.python.external.ExternalPythonRuntimeServiceImpl;
import io.cloudslang.runtime.impl.python.external.ExternalPythonScriptException;
import io.cloudslang.runtime.impl.python.external.StatefulRestEasyClientsHolder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Semaphore;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.springframework.util.MimeTypeUtils;

public class ExternalPythonExecutorServiceImpl
extends ExternalPythonRuntimeServiceImpl
implements PythonRuntimeService {
    private static final Logger logger = LogManager.getLogger(ExternalPythonExecutorServiceImpl.class);
    private static final String EXTERNAL_PYTHON_PORT = System.getProperty("python.port", String.valueOf(8001));
    private static final String EXTERNAL_PYTHON_EXECUTOR_URL = "https://localhost:" + EXTERNAL_PYTHON_PORT;
    private static final String EXTERNAL_PYTHON_EXECUTOR_EVAL_PATH = "/rest/v1/eval";
    private final ResteasyClient restEasyClient;
    private final ObjectMapper objectMapper;

    public ExternalPythonExecutorServiceImpl(StatefulRestEasyClientsHolder statefulRestEasyClient, Semaphore executionControlSemaphore, Semaphore testingControlSemaphore) {
        super(executionControlSemaphore, testingControlSemaphore);
        this.restEasyClient = statefulRestEasyClient.getRestEasyClient();
        JsonFactory factory = new JsonFactory();
        factory.enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
        factory.enable(JsonWriteFeature.ESCAPE_NON_ASCII.mappedFeature());
        this.objectMapper = new ObjectMapper(factory);
    }

    @Override
    public PythonEvaluationResult eval(String prepareEnvironmentScript, String script, Map<String, Serializable> vars) {
        try {
            return this.getPythonEvaluationResult(script, prepareEnvironmentScript, vars);
        }
        catch (JsonProcessingException ie) {
            logger.error((Object)ie);
            throw new ExternalPythonScriptException("Execution was interrupted while waiting for a python permit.");
        }
    }

    @Override
    public PythonExecutionResult exec(Set<String> dependencies, String script, Map<String, Serializable> vars) {
        return super.exec(dependencies, script, vars);
    }

    @Override
    public PythonEvaluationResult test(String prepareEnvironmentScript, String script, Map<String, Serializable> vars, long timeout) {
        return super.test(prepareEnvironmentScript, script, vars, timeout);
    }

    private PythonEvaluationResult getPythonEvaluationResult(String expression, String prepareEnvironmentScript, Map<String, Serializable> context) throws JsonProcessingException {
        String accessedResources = "accessed_resources_set";
        String payload = this.generatePayloadForEval(expression, prepareEnvironmentScript, context);
        EvaluationResults scriptResults = this.executeRequestOnPythonServer("POST", payload);
        String exception = scriptResults.getException();
        if (StringUtils.isNotEmpty((String)exception)) {
            logger.error(String.format("Failed to execute script {%s}", exception));
            throw new ExternalPythonEvalException(exception);
        }
        context.put(accessedResources, (Serializable)((Object)scriptResults.getAccessedResources()));
        return new PythonEvaluationResult(this.processReturnResult(scriptResults), context);
    }

    private EvaluationResults executeRequestOnPythonServer(String method, String payload) throws JsonProcessingException {
        Response scriptResponse = this.restEasyClient.target(EXTERNAL_PYTHON_EXECUTOR_URL).path(EXTERNAL_PYTHON_EXECUTOR_EVAL_PATH).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Content-Type", (Object)MimeTypeUtils.APPLICATION_JSON).header("Authorization", (Object)this.getBasicAuthorizationHeaderValue()).build(method, Entity.entity((Object)payload, (MediaType)MediaType.APPLICATION_JSON_TYPE)).invoke();
        return (EvaluationResults)this.objectMapper.readValue((String)scriptResponse.readEntity(String.class), EvaluationResults.class);
    }

    private Properties readFromPropertiesFiles() {
        String filename = "pythonServer.properties";
        Properties prop = new Properties();
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream(filename);){
            prop.load(input);
        }
        catch (IOException exception) {
            logger.error(String.format("Failed to read from file", exception));
            throw new RuntimeException(exception);
        }
        return prop;
    }

    private String getBasicAuthorizationHeaderValue() {
        Properties prop = this.readFromPropertiesFiles();
        String username = prop.getProperty("username");
        String password = prop.getProperty("password");
        String encodedAuth = Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
        return "Basic " + encodedAuth;
    }

    private String generatePayloadForEval(String expression, String prepareEnvironmentScript, Map<String, Serializable> context) throws JsonProcessingException {
        HashMap<String, Object> payload = new HashMap<String, Object>(3);
        payload.put("expression", expression);
        payload.put("envSetup", prepareEnvironmentScript);
        payload.put("context", (Serializable)((Object)context));
        return this.objectMapper.writeValueAsString(payload);
    }

    private Serializable processReturnResult(EvaluationResults results) throws JsonProcessingException {
        EvaluationResults.ReturnType returnType = results.getReturnType();
        if (returnType == null) {
            throw new RuntimeException("Missing return type for return result.");
        }
        switch (returnType) {
            case BOOLEAN: {
                return Boolean.valueOf(results.getReturnResult());
            }
            case INTEGER: {
                return new BigInteger(results.getReturnResult());
            }
            case LIST: {
                return (Serializable)this.objectMapper.readValue(results.getReturnResult(), (TypeReference)new TypeReference<ArrayList<Serializable>>(){});
            }
        }
        return results.getReturnResult();
    }
}

