/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python.external;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;

public class ExternalPythonTestRunnable
implements Runnable {
    private final ProcessBuilder processBuilder;
    private final String payload;
    private final AtomicReference<Process> processRef;
    private final AtomicReference<String> result;
    private final AtomicReference<RuntimeException> exception;

    public ExternalPythonTestRunnable(ProcessBuilder processBuilder, String payload) {
        this.processBuilder = processBuilder;
        this.payload = payload;
        this.processRef = new AtomicReference();
        this.result = new AtomicReference();
        this.exception = new AtomicReference();
    }

    @Override
    public void run() {
        try {
            String line;
            Process process = this.processBuilder.start();
            this.processRef.set(process);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8));
            printWriter.println(this.payload);
            printWriter.flush();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder returnResult = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                returnResult.append(line);
            }
            String retValue = returnResult.toString();
            retValue = retValue.replace("\\\\n", "\\n");
            this.result.set(retValue);
            this.exception.set(null);
        }
        catch (IOException ioException) {
            this.result.set(null);
            this.exception.set(new RuntimeException("Script execution failed: ", ioException));
        }
    }

    public String getResult() {
        return this.result.get();
    }

    public RuntimeException getException() {
        return this.exception.get();
    }

    public void destroyProcess() {
        Process process = this.processRef.get();
        if (process != null) {
            try {
                process.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

