/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python.external;

import java.util.Objects;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpPoolCleanupTask
extends TimerTask
implements Runnable {
    private static final Logger logger = LogManager.getLogger(HttpPoolCleanupTask.class);
    private static final int IDLE_CONNECTIONS_TIMEOUT_IN_SECONDS = Integer.getInteger("restClient.idleConnectionTimeoutSeconds", 210);
    private final ClientConnectionManager clientConnectionManager;

    public HttpPoolCleanupTask(ClientConnectionManager clientConnectionManager) {
        this.clientConnectionManager = Objects.requireNonNull(clientConnectionManager, "Connection manager cannot be null");
    }

    @Override
    public void run() {
        this.cleanup();
    }

    private void cleanup() {
        try {
            this.clientConnectionManager.closeExpiredConnections();
        }
        catch (Exception closeExpiredConnectionsException) {
            logger.error("Could not close expired connections: ", (Throwable)closeExpiredConnectionsException);
        }
        try {
            this.clientConnectionManager.closeIdleConnections((long)IDLE_CONNECTIONS_TIMEOUT_IN_SECONDS, TimeUnit.SECONDS);
        }
        catch (Exception closeIdleConnectionsException) {
            logger.error("Could not close idle connections: ", (Throwable)closeIdleConnectionsException);
        }
    }
}

