/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python.external;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ResourceScriptResolver {
    private static final byte[] execScriptAsBytes = ResourceScriptResolver.loadScriptFromResource("main.py");
    private static final String evalScriptAsString = ResourceScriptResolver.loadScriptFromResourceAsString("eval.py");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] loadScriptFromResource(String resourceName) {
        try (InputStream stream = Objects.requireNonNull(ResourceScriptResolver.class.getClassLoader(), "Could not get not-null classloader").getResourceAsStream(resourceName);){
            byte[] byArray = IOUtils.toByteArray((InputStream)Objects.requireNonNull(stream, "Could not locate resource '" + resourceName + "'"));
            return byArray;
        }
        catch (IOException ioEx) {
            throw new RuntimeException("Could not load resource '" + resourceName + "': ", ioEx);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadScriptFromResourceAsString(String resourceName) {
        try (InputStream stream = Objects.requireNonNull(ResourceScriptResolver.class.getClassLoader(), "Could not get not-null classloader").getResourceAsStream(resourceName);){
            InputStream safeStream = Objects.requireNonNull(stream, "Could not locate resource '" + resourceName + "'");
            String string = StringUtils.join((Iterable)IOUtils.readLines((InputStream)safeStream, (Charset)StandardCharsets.UTF_8), (String)"\n");
            return string;
        }
        catch (IOException ioEx) {
            throw new RuntimeException("Could not load resource '" + resourceName + "': ", ioEx);
        }
    }

    public static byte[] loadExecScriptAsBytes() {
        return execScriptAsBytes;
    }

    public static String loadEvalScriptAsString() {
        return evalScriptAsString;
    }
}

