/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python.external;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.conn.ClientConnectionManager;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;
import org.springframework.stereotype.Component;

@Component(value="restEasyClientWrapper")
public class RestEasyClientWrapper {
    public Pair<ResteasyClient, ClientConnectionManager> getClientForRemoteConfiguration(int maxConnections, int maxPerRoute) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        ResteasyClientBuilder resteasyClientBuilder = (ResteasyClientBuilder)ResteasyClientBuilder.newBuilder();
        resteasyClientBuilder.maxPooledPerRoute(maxPerRoute).connectionPoolSize(maxConnections);
        SSLContext sslContext = SSLContext.getDefault();
        resteasyClientBuilder.sslContext(sslContext);
        ResteasyClient restEasyClient = resteasyClientBuilder.build();
        ClientHttpEngine clientHttpEngine = restEasyClient.httpEngine();
        if (!(clientHttpEngine instanceof ApacheHttpClient43Engine)) {
            throw new IllegalStateException("Rest easy does not use apache http client backend");
        }
        ApacheHttpClient43Engine apacheHttpClient43Engine = (ApacheHttpClient43Engine)clientHttpEngine;
        ClientConnectionManager connectionManager = apacheHttpClient43Engine.getHttpClient().getConnectionManager();
        return ImmutablePair.of((Object)restEasyClient, (Object)connectionManager);
    }
}

