/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python.external;

import io.cloudslang.runtime.impl.python.external.HttpPoolCleanupTask;
import io.cloudslang.runtime.impl.python.external.RestEasyClientWrapper;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.conn.ClientConnectionManager;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="statefulRestEasyClientsHolder")
public class StatefulRestEasyClientsHolder {
    private static final int MAX_CONNECTIONS = 60;
    private static final long TIMER_TASK_DELAY_MILLIS = 30000L;
    private static final String TIMER_THREAD_NAME = "restEasyClientTimer";
    private final RestEasyClientWrapper restEasyClientWrapper;
    private final ResteasyClient restEasyClient;
    private final Object cleanupLock = new Object();
    private final HashMap<String, HttpPoolCleanupTask> cleanupTaskMap = new HashMap();
    private final HashMap<String, Timer> timerMap = new HashMap();

    @Autowired
    public StatefulRestEasyClientsHolder(RestEasyClientWrapper restEasyClientWrapper) {
        this.restEasyClientWrapper = restEasyClientWrapper;
        this.restEasyClient = this.generateClientForInitialization(TIMER_THREAD_NAME, 60, 60);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        Object object = this.cleanupLock;
        synchronized (object) {
            for (Map.Entry<String, HttpPoolCleanupTask> entry : this.cleanupTaskMap.entrySet()) {
                Timer timer = new Timer(entry.getKey(), false);
                timer.scheduleAtFixedRate((TimerTask)entry.getValue(), 180000L, 30000L);
                this.timerMap.put(entry.getKey(), timer);
            }
        }
    }

    @PreDestroy
    public void preDestroy() {
        this.doCloseRestEasyClient();
    }

    public ResteasyClient getRestEasyClient() {
        return this.restEasyClient;
    }

    public void closeRestEasyClient() {
        this.doCloseRestEasyClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResteasyClient generateClientForInitialization(String name, int maxConnections, int maxPerRoute) {
        try {
            Pair<ResteasyClient, ClientConnectionManager> pairClientConnectionManager = this.restEasyClientWrapper.getClientForRemoteConfiguration(maxConnections, maxPerRoute);
            Object object = this.cleanupLock;
            synchronized (object) {
                this.cleanupTaskMap.put(name, new HttpPoolCleanupTask((ClientConnectionManager)pairClientConnectionManager.getRight()));
            }
            return (ResteasyClient)pairClientConnectionManager.getLeft();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException("Could not create stateful rest easy client: ", e);
        }
    }

    private void doCloseRestEasyClient() {
        this.restEasyClient.close();
        this.doCloseTimerByKey(TIMER_THREAD_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCloseTimerByKey(String key) {
        Object object = this.cleanupLock;
        synchronized (object) {
            this.cleanupTaskMap.remove(key);
            Timer crtTimer = this.timerMap.remove(key);
            this.closeTimer(crtTimer);
        }
    }

    private void closeTimer(Timer timer) {
        try {
            timer.cancel();
            timer.purge();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

