/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python.pool;

import io.cloudslang.runtime.impl.python.EmbeddedPythonExecutorWrapper;
import io.cloudslang.runtime.impl.python.pool.ViburEmbeddedPythonFactory;
import io.cloudslang.runtime.impl.python.pool.ViburEmbeddedPythonPoolService;
import java.util.concurrent.TimeUnit;
import org.vibur.objectpool.ConcurrentPool;
import org.vibur.objectpool.PoolObjectFactory;
import org.vibur.objectpool.util.ConcurrentLinkedQueueCollection;

public class ViburEmbeddedPythonPoolServiceImpl
implements ViburEmbeddedPythonPoolService {
    private final ConcurrentPool<EmbeddedPythonExecutorWrapper> poolService;
    private final long timeout;

    public ViburEmbeddedPythonPoolServiceImpl(ConcurrentLinkedQueueCollection<EmbeddedPythonExecutorWrapper> collection, int minPoolSize, int maxPoolSize) {
        this.poolService = new ConcurrentPool(collection, (PoolObjectFactory)new ViburEmbeddedPythonFactory(), minPoolSize, maxPoolSize, false);
        this.timeout = Long.getLong("jython.executor.checkoutTimeoutSeconds", 10800L);
    }

    @Override
    public EmbeddedPythonExecutorWrapper tryTakeWithTimeout() {
        return (EmbeddedPythonExecutorWrapper)this.poolService.tryTake(this.timeout, TimeUnit.SECONDS);
    }

    @Override
    public void restore(EmbeddedPythonExecutorWrapper pooledObject) {
        this.poolService.restore((Object)pooledObject);
    }

    @Override
    public void close() {
        try {
            this.poolService.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

