/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python.security;

import java.io.StringWriter;
import java.util.function.Supplier;

public class BoundedStringWriter
extends StringWriter {
    private static final int defaultMaxChars = Integer.getInteger("jython.standardStreams.maxLength", 1000);
    private static final int nullStringLength = "null".length();
    private final Supplier<RuntimeException> exceptionSupplier;
    private final int maxChars = defaultMaxChars;

    public BoundedStringWriter(Supplier<RuntimeException> exceptionSupplier) {
        this.exceptionSupplier = exceptionSupplier;
    }

    @Override
    public void write(int c) {
        this.validateBounds(1);
        super.write(c);
    }

    @Override
    public void write(char[] charArray, int off, int len) {
        if (len > 0) {
            this.validateBounds(len);
        }
        super.write(charArray, off, len);
    }

    @Override
    public void write(String str) {
        this.validateBounds(str == null ? nullStringLength : str.length());
        super.write(str);
    }

    @Override
    public void write(String str, int off, int len) {
        if (len > 0) {
            this.validateBounds(len);
        }
        super.write(str, off, len);
    }

    @Override
    public StringWriter append(CharSequence csq) {
        this.validateBounds(csq == null ? nullStringLength : csq.length());
        return super.append(csq);
    }

    @Override
    public StringWriter append(CharSequence csq, int start, int end) {
        this.validateBounds(csq == null ? nullStringLength : csq.subSequence(start, end).length());
        return super.append(csq, start, end);
    }

    @Override
    public StringWriter append(char c) {
        this.validateBounds(1);
        return super.append(c);
    }

    private void validateBounds(int toAddNumberOfChars) {
        if (this.getBuffer().length() + toAddNumberOfChars > this.maxChars) {
            throw this.exceptionSupplier.get();
        }
    }
}

