/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.impl.python;

import io.cloudslang.runtime.api.python.PythonEvaluationResult;
import io.cloudslang.runtime.api.python.PythonExecutionResult;
import io.cloudslang.runtime.impl.Executor;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyClass;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFunction;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyType;
import org.python.util.PythonInterpreter;

public class PythonExecutor
implements Executor {
    public static final String THREADED_MODULES_ISSUE = "No module named";
    private static final Logger logger = Logger.getLogger(PythonExecutor.class);
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final PythonInterpreter GLOBAL_INTERPRETER = new ThreadSafePythonInterpreter(null);
    public static final int RETRIES_NUMBER_ON_THREADED_ISSUE = 3;
    private final PythonInterpreter interpreter;
    private final Lock allocationLock = new ReentrantLock();
    private int allocations = 0;
    private boolean markedClosed = false;
    private boolean actuallyClosed = false;
    private final Set<String> dependencies;

    public PythonExecutor() {
        this(Collections.emptySet());
    }

    public PythonExecutor(Set<String> dependencies) {
        this.dependencies = dependencies;
        this.interpreter = this.initInterpreter(dependencies);
    }

    protected PythonInterpreter initInterpreter(Set<String> dependencies) {
        logger.info((Object)("Creating python interpreter with [" + dependencies.size() + "] dependencies [" + dependencies + "]"));
        if (!dependencies.isEmpty()) {
            PySystemState systemState = new PySystemState();
            for (String dependency : dependencies) {
                systemState.path.append((PyObject)new PyString(dependency));
            }
            return new ThreadSafePythonInterpreter(systemState);
        }
        return GLOBAL_INTERPRETER;
    }

    public PythonExecutionResult exec(String script, Map<String, Serializable> callArguments) {
        this.checkValidInterpreter();
        this.initInterpreter();
        this.prepareInterpreterContext(callArguments);
        Exception originException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.exec(script);
            }
            catch (Exception e) {
                if (!this.isThreadsRelatedModuleIssue(e)) {
                    throw new RuntimeException("Error executing python script: " + e, e);
                }
                if (originException != null) continue;
                originException = e;
                continue;
            }
        }
        throw new RuntimeException("Error executing python script: " + originException, originException);
    }

    private boolean isThreadsRelatedModuleIssue(Exception e) {
        if (e instanceof PyException) {
            PyException pyException = (PyException)e;
            String message = pyException.value.toString();
            return message.contains(THREADED_MODULES_ISSUE);
        }
        return false;
    }

    private PythonExecutionResult exec(String script) {
        this.interpreter.exec(script);
        Iterator localsIterator = this.interpreter.getLocals().asIterable().iterator();
        HashMap<String, Serializable> returnValue = new HashMap<String, Serializable>();
        while (localsIterator.hasNext()) {
            PyObject value;
            String key = ((PyObject)localsIterator.next()).asString();
            if (this.keyIsExcluded(key, value = this.interpreter.get(key))) continue;
            Serializable javaValue = this.resolveJythonObjectToJavaExec(value, key);
            returnValue.put(key, javaValue);
        }
        return new PythonExecutionResult(returnValue);
    }

    private Map<String, Serializable> getPythonLocals() {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        if (this.interpreter.getLocals() != null) {
            for (PyObject pyObject : this.interpreter.getLocals().asIterable()) {
                PyObject value;
                String key = pyObject.asString();
                if (this.keyIsExcluded(key, value = this.interpreter.get(key))) continue;
                result.put(key, (Serializable)value);
            }
        }
        return result;
    }

    public PythonEvaluationResult eval(String prepareEnvironmentScript, String expr, Map<String, Serializable> context) {
        this.checkValidInterpreter();
        try {
            this.initInterpreter();
            this.prepareInterpreterContext(context);
            return new PythonEvaluationResult(this.eval(prepareEnvironmentScript, expr), this.getPythonLocals());
        }
        catch (PyException exception) {
            throw new RuntimeException("Error in running script expression: '" + expr + "',\n\tException is: " + this.handleExceptionSpecialCases(exception.value.toString()), exception);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error in running script expression: '" + expr + "',\n\tException is: " + this.handleExceptionSpecialCases(exception.getMessage()), exception);
        }
    }

    private String handleExceptionSpecialCases(String message) {
        String processedMessage = message;
        if (StringUtils.isNotEmpty((String)message) && message.contains("get_sp") && message.contains("not defined")) {
            processedMessage = message + ". Make sure to use correct syntax for the function: get_sp('fully.qualified.name', optional_default_value).";
        }
        return processedMessage;
    }

    private void checkValidInterpreter() {
        if (this.isClosed()) {
            throw new RuntimeException("Trying to execute script on already closed python interpreter");
        }
    }

    protected Serializable eval(String prepareEnvironmentScript, String script) {
        if (this.interpreter.get(TRUE) == null) {
            this.interpreter.set(TRUE, (Object)Boolean.TRUE);
        }
        if (this.interpreter.get(FALSE) == null) {
            this.interpreter.set(FALSE, (Object)Boolean.FALSE);
        }
        if (prepareEnvironmentScript != null && !prepareEnvironmentScript.isEmpty()) {
            this.interpreter.exec(prepareEnvironmentScript);
        }
        PyObject evalResultAsPyObject = this.interpreter.eval(script);
        Serializable evalResult = this.resolveJythonObjectToJavaEval(evalResultAsPyObject, script);
        return evalResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allocate() {
        this.allocationLock.lock();
        try {
            ++this.allocations;
        }
        finally {
            this.allocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.allocationLock.lock();
        try {
            --this.allocations;
            if (this.markedClosed && this.allocations == 0) {
                this.close();
            }
        }
        finally {
            this.allocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block5: {
            this.allocationLock.lock();
            try {
                this.markedClosed = true;
                if (this.interpreter == GLOBAL_INTERPRETER || this.allocations != 0) break block5;
                logger.info((Object)("Removing LRU python executor for dependencies [" + this.dependencies + "]"));
                try {
                    this.interpreter.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.actuallyClosed = true;
            }
            finally {
                this.allocationLock.unlock();
            }
        }
    }

    public boolean isClosed() {
        return this.actuallyClosed;
    }

    private void initInterpreter() {
        this.interpreter.setLocals((PyObject)new PyStringMap());
    }

    private void prepareInterpreterContext(Map<String, Serializable> context) {
        for (Map.Entry<String, Serializable> entry : context.entrySet()) {
            this.interpreter.set(entry.getKey(), (Object)entry.getValue());
        }
    }

    private Serializable resolveJythonObjectToJavaExec(PyObject value, String key) {
        String errorMessage = "Non-serializable values are not allowed in the output context of a Python script:\n\tConversion failed for '" + key + "' (" + value + "),\n" + "\tThe error can be solved by removing the variable from the context in the script: e.g. 'del " + key + "'.\n";
        return this.resolveJythonObjectToJava(value, errorMessage);
    }

    private Serializable resolveJythonObjectToJavaEval(PyObject value, String expression) {
        String errorMessage = "Evaluation result for a Python expression should be serializable:\n\tConversion failed for '" + expression + "' (" + value + ").\n";
        return this.resolveJythonObjectToJava(value, errorMessage);
    }

    private Serializable resolveJythonObjectToJava(PyObject value, String errorMessage) {
        if (value == null) {
            return null;
        }
        if (value instanceof PyBoolean) {
            PyBoolean pyBoolean = (PyBoolean)value;
            return Boolean.valueOf(pyBoolean.getBooleanValue());
        }
        try {
            return (Serializable)Py.tojava((PyObject)value, Serializable.class);
        }
        catch (PyException e) {
            PyType type;
            String typeName;
            PyObject typeObject = e.type;
            if (typeObject instanceof PyType && "TypeError".equals(typeName = (type = (PyType)typeObject).getName())) {
                throw new RuntimeException(errorMessage, e);
            }
            throw e;
        }
    }

    private boolean keyIsExcluded(String key, PyObject value) {
        return key.startsWith("__") && key.endsWith("__") || value instanceof PyFile || value instanceof PyModule || value instanceof PyFunction || value instanceof PySystemState || value instanceof PyClass;
    }

    static {
        GLOBAL_INTERPRETER.exec("import io");
    }

    private static class ThreadSafePythonInterpreter
    extends PythonInterpreter {
        ThreadSafePythonInterpreter() {
            this(null);
        }

        ThreadSafePythonInterpreter(PySystemState systemState) {
            super(null, systemState, true);
        }
    }
}

