/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.engine.data;

import io.cloudslang.engine.data.IdentityGenerator;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class SimpleHiloIdentifierGenerator
implements IdentifierGenerator,
IdentityGenerator {
    private final Logger logger = Logger.getLogger(this.getClass());
    static final String TABLE_NAME = "OO_HILO";
    static final String SQL_SELECT = "SELECT NEXT_HI FROM OO_HILO";
    static final String SQL_UPDATE = "UPDATE OO_HILO SET NEXT_HI = NEXT_HI+1";
    static final String SQL_LOCK = "UPDATE OO_HILO SET NEXT_HI = NEXT_HI";
    static final long CHUNK_SIZE = 100000L;
    private static DataSource dataSource;
    private int currentChunk;
    private long currentId;
    private Lock lock = new ReentrantLock();

    public SimpleHiloIdentifierGenerator() {
        this.updateCurrentChunk();
    }

    public static void setDataSource(DataSource injectedDataSource) {
        dataSource = injectedDataSource;
    }

    @Override
    public Long next() {
        return (Long)this.generate(null, null);
    }

    @Override
    public List<Long> bulk(int bulkSize) {
        ArrayList<Long> idsList = new ArrayList<Long>();
        for (int i = 0; i < bulkSize; ++i) {
            idsList.add(this.next());
        }
        return idsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        this.lock.lock();
        try {
            long id = ++this.currentId;
            if (id > 100000L) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"ID has reached chunk size");
                }
                this.updateCurrentChunk();
                id = ++this.currentId;
            }
            Long l = (long)this.currentChunk * 100000L + id;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateCurrentChunk() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Updating HILO chunk...");
        }
        long t = System.currentTimeMillis();
        try (Connection conn = dataSource.getConnection();){
            conn.setAutoCommit(false);
            JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)new SingleConnectionDataSource(conn, true));
            jdbcTemplate.update(SQL_LOCK);
            this.currentChunk = (Integer)jdbcTemplate.queryForObject(SQL_SELECT, Integer.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Current chunk: " + this.currentChunk));
            }
            jdbcTemplate.execute(SQL_UPDATE);
            jdbcTemplate.execute("commit");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Updating HILO chunk done in " + (System.currentTimeMillis() - t) + " ms"));
            }
            this.currentId = 0L;
        }
        catch (SQLException e) {
            this.logger.error((Object)"Unable to update current chunk", (Throwable)e);
            throw new IllegalStateException("Unable to update current chunk");
        }
    }
}

