/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.engine.partitions.services;

import io.cloudslang.engine.partitions.entities.PartitionGroup;
import io.cloudslang.engine.partitions.repositories.PartitionGroupRepository;
import io.cloudslang.engine.partitions.services.PartitionService;
import io.cloudslang.engine.partitions.services.PartitionUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public final class PartitionServiceImpl
implements PartitionService {
    private final Logger logger = Logger.getLogger(this.getClass());
    public static final int MIN_GROUP_SIZE = 2;
    @Autowired
    private PartitionGroupRepository repository;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private PartitionUtils partitionUtils;

    @Transactional
    public void createPartitionGroup(String groupName, int groupSize, long timeThreshold, long sizeThreshold) {
        Validate.notEmpty((String)groupName, (String)"Group name is empty or null");
        Validate.isTrue((groupSize >= 2 ? 1 : 0) != 0, (String)this.formatMessage2Small("Group size", groupSize, 2L));
        this.repository.save(new PartitionGroup(groupName, groupSize, timeThreshold, sizeThreshold));
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Partition group [" + groupName + "] was created, with group size " + groupSize + ", and timeThreshold " + timeThreshold + ", and sizeThreshold " + sizeThreshold));
        }
    }

    @Transactional
    public void updatePartitionGroup(String groupName, int groupSize, long timeThreshold, long sizeThreshold) {
        Validate.notEmpty((String)groupName, (String)"Group name is empty or null");
        Validate.isTrue((groupSize >= 2 ? 1 : 0) != 0, (String)this.formatMessage2Small("Group size", groupSize, 2L));
        PartitionGroup partitionGroup = this.repository.findByName(groupName);
        if (partitionGroup != null) {
            partitionGroup.setName(groupName);
            partitionGroup.setGroupSize(groupSize);
            partitionGroup.setTimeThreshold(timeThreshold);
            partitionGroup.setSizeThreshold(sizeThreshold);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Partition group [" + groupName + "] was updated, with group size " + groupSize + ", and timeThreshold " + timeThreshold + ", and sizeThreshold " + sizeThreshold));
            }
        }
    }

    private String formatMessage2Small(String param, long value, long limit) {
        return param + " is too small: " + value + " (min " + limit + ")";
    }

    @Transactional(readOnly=true)
    public PartitionGroup readPartitionGroup(String groupName) {
        Validate.notEmpty((String)groupName, (String)"Group name is empty or null");
        return this.repository.findByName(groupName);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean rollPartitions(String groupName) {
        Validate.notEmpty((String)groupName, (String)"Group name is empty or null");
        Validate.isTrue((this.repository.lock(groupName) == 1 ? 1 : 0) != 0, (String)("Unknown partition group [" + groupName + "]"));
        PartitionGroup partitionGroup = this.repository.findByName(groupName);
        if (!this.shouldBeRolled(partitionGroup)) {
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rolling partition group [" + groupName + "]"));
        }
        long t = System.currentTimeMillis();
        partitionGroup.setActivePartition(this.partitionUtils.partitionAfter(partitionGroup.getActivePartition(), partitionGroup.getGroupSize())).setLastRollTime(System.currentTimeMillis());
        this.jdbcTemplate.execute(this.SQL("truncate table " + this.table(partitionGroup)));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Group [" + groupName + "]: active partition is " + partitionGroup.getActivePartition() + " (rolled in " + (System.currentTimeMillis() - t) + " ms)"));
        }
        return true;
    }

    private boolean shouldBeRolled(PartitionGroup partitionGroup) {
        if (partitionGroup.getTimeThreshold() != -1L) {
            long lastRoll = System.currentTimeMillis() - partitionGroup.getLastRollTime();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Partition group [" + partitionGroup.getName() + "] was rolled before " + lastRoll + " ms"));
            }
            if (lastRoll > partitionGroup.getTimeThreshold()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Partition group [" + partitionGroup.getName() + "] has reached a time threshold and will be rolled"));
                }
                return true;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Time threshold wasn't reached -> timeThreshold-lastRoll = " + (partitionGroup.getTimeThreshold() - lastRoll) + " ms"));
            }
        }
        if (partitionGroup.getSizeThreshold() != -1L) {
            long partitionSize;
            Number number = (Number)this.jdbcTemplate.queryForObject(this.SQL("select count(*) from " + this.table(partitionGroup)), Long.class);
            long l = partitionSize = number != null ? (long)number.intValue() : 0L;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Partition group [" + partitionGroup.getName() + "]: active partition=" + partitionGroup.getActivePartition() + ", size=" + partitionSize));
            }
            if (partitionSize >= partitionGroup.getSizeThreshold()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Partition group [" + partitionGroup.getName() + "] has reached a records limit and will be rolled"));
                }
                return true;
            }
        }
        return false;
    }

    private String table(PartitionGroup partitionGroup) {
        return this.partitionUtils.tableName(partitionGroup.getName(), partitionGroup.getActivePartition());
    }

    private String SQL(String sql) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("SQL: " + sql));
        }
        return sql;
    }
}

