/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.engine.partitions.services;

import io.cloudslang.engine.partitions.entities.PartitionGroup;
import io.cloudslang.engine.partitions.services.PartitionCallback;
import io.cloudslang.engine.partitions.services.PartitionService;
import io.cloudslang.engine.partitions.services.PartitionTemplate;
import io.cloudslang.engine.partitions.services.PartitionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;

public class PartitionTemplateImpl
implements PartitionTemplate,
BeanNameAware {
    private final Logger logger = Logger.getLogger(this.getClass());
    @Autowired
    private PartitionUtils partitionUtils;
    @Autowired
    private PartitionService service;
    @Autowired
    private ApplicationContext applicationContext;
    private int groupSize = 4;
    private long timeThreshold = 14400000L;
    private long sizeThreshold = 1000000L;
    private String groupName;
    private PartitionCallback[] callbacks = new PartitionCallback[0];
    private ThreadLocal<String> origThreadName = new ThreadLocal();

    @PostConstruct
    void registerPartitionGroup() {
        PartitionGroup partitionGroup = this.service.readPartitionGroup(this.groupName);
        if (partitionGroup == null) {
            this.service.createPartitionGroup(this.groupName, this.groupSize, this.timeThreshold, this.sizeThreshold);
        } else if (partitionGroup.getGroupSize() != this.groupSize || partitionGroup.getSizeThreshold() != this.sizeThreshold || partitionGroup.getTimeThreshold() != this.timeThreshold) {
            this.service.updatePartitionGroup(this.groupName, this.groupSize, this.timeThreshold, this.sizeThreshold);
        }
    }

    public String activeTable() {
        PartitionGroup group = this.service.readPartitionGroup(this.groupName);
        return group == null ? null : this.partitionUtils.tableName(this.groupName, group.getActivePartition());
    }

    public String previousTable() {
        PartitionGroup group = this.service.readPartitionGroup(this.groupName);
        return group == null ? null : this.partitionUtils.tableName(this.groupName, this.partitionUtils.partitionBefore(group.getActivePartition(), group.getGroupSize()));
    }

    public List<String> reversedTables() {
        PartitionGroup group = this.service.readPartitionGroup(this.groupName);
        if (group == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        int partition = group.getActivePartition();
        for (int i = 0; i < group.getGroupSize(); ++i) {
            result.add(this.partitionUtils.tableName(this.groupName, partition));
            partition = this.partitionUtils.partitionBefore(partition, group.getGroupSize());
        }
        return result;
    }

    public void onRolling() {
        this.runCallbackOnRollingPartitions();
        boolean wasRolled = this.service.rollPartitions(this.groupName);
        if (wasRolled) {
            this.runCallbackOnRollingPartitions();
        }
    }

    private void runCallbackOnRollingPartitions() {
        if (!ArrayUtils.isEmpty((Object[])this.callbacks)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Run callbacks on roll partition group [" + this.groupName + "]"));
            }
            for (PartitionCallback callback : this.callbacks) {
                try {
                    callback.doCallback(this.previousTable(), this.activeTable());
                }
                catch (RuntimeException ex) {
                    this.logger.error((Object)("Partition group [" + this.groupName + "]: callback [" + callback.getClass().getSimpleName() + "] failed on rolling partitions"), (Throwable)ex);
                }
            }
        }
    }

    public void setBeanName(String name) {
        this.groupName = name;
    }

    @Required
    public void setGroupSize(int groupSize) {
        this.groupSize = groupSize;
    }

    @Required
    public void setTimeThreshold(long timeThreshold) {
        this.timeThreshold = timeThreshold;
    }

    @Required
    public void setSizeThreshold(long sizeThreshold) {
        this.sizeThreshold = sizeThreshold;
    }

    public void setCallbacks(PartitionCallback ... callbacks) {
        this.callbacks = (PartitionCallback[])ArrayUtils.addAll((Object[])this.callbacks, (Object[])callbacks);
    }

    public void setCallbackClass(Class<? extends PartitionCallback> callbackClass) {
        this.logger.info((Object)("Registering callback class " + callbackClass.getSimpleName() + " for partition group [" + this.groupName + "]"));
        Map callbacksMap = this.applicationContext.getBeansOfType(callbackClass);
        if (!callbacksMap.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Partition group [" + this.groupName + "] callbacks found: " + callbacksMap.keySet()));
            }
            Object[] callbacksByClass = callbacksMap.values().toArray(new PartitionCallback[callbacksMap.size()]);
            this.callbacks = (PartitionCallback[])ArrayUtils.addAll((Object[])this.callbacks, (Object[])callbacksByClass);
        } else {
            this.logger.warn((Object)("Partition group [" + this.groupName + "]: no callbacks found by class " + callbackClass));
        }
    }

    public String toString() {
        return "Partition-" + this.groupName;
    }
}

