/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.engine.versioning.services;

import io.cloudslang.engine.versioning.entities.VersionCounter;
import io.cloudslang.engine.versioning.repositories.VersionRepository;
import io.cloudslang.engine.versioning.services.VersionService;
import java.util.Date;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.transaction.annotation.Transactional;

public final class VersionServiceImpl
implements VersionService {
    private final Logger logger = Logger.getLogger(this.getClass());
    @Autowired
    private VersionRepository versionRepository;

    @Transactional
    @Cacheable(value={"recovery_version"})
    public long getCurrentVersion(String counterName) {
        VersionCounter versionCounter = this.versionRepository.findByCounterName(counterName);
        if (versionCounter == null) {
            throw new IllegalStateException("No VersionCounter for counterName:" + counterName);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("got version :" + (Object)((Object)versionCounter) + ", for version named:" + counterName + " , at : " + new Date()));
        }
        return versionCounter.getVersionCount();
    }

    @Transactional
    public void incrementVersion(String counterName) {
        int result = this.versionRepository.incrementCounterByName(counterName);
        if (result != 1) {
            throw new IllegalStateException("for counterName:" + counterName + ", got row count of :" + result);
        }
    }
}

