/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.engine.node.repositories;

import io.cloudslang.engine.node.entities.WorkerNode;
import io.cloudslang.score.api.nodes.WorkerStatus;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

public interface WorkerNodeRepository
extends JpaRepository<WorkerNode, Long> {
    public WorkerNode findByUuidAndDeleted(String var1, boolean var2);

    public WorkerNode findByUuid(String var1);

    public List<WorkerNode> findByActiveAndDeleted(boolean var1, boolean var2);

    public List<WorkerNode> findByDeletedOrderByIdAsc(boolean var1);

    public List<WorkerNode> findByActiveAndStatusAndDeleted(boolean var1, WorkerStatus var2, boolean var3);

    @Query(value="select w from WorkerNode w where (w.active = ?1) and (w.status = ?2) and (w.deleted = ?3) and ((w.versionId = ?4) or (w.versionId is null))")
    public List<WorkerNode> findByActiveAndStatusAndDeletedAndVersionId(boolean var1, WorkerStatus var2, boolean var3, String var4);

    public List<WorkerNode> findByGroupsAndDeleted(String var1, boolean var2);

    @Query(value="select w.uuid from WorkerNode w where (w.ackVersion < ?1) and w.status <> ?2")
    public List<String> findNonRespondingWorkers(long var1, WorkerStatus var3);

    @Query(value="select distinct g from WorkerNode w join w.groups g where w.deleted = false")
    public List<String> findGroups();

    @Query(value="update WorkerNode w set w.ackTime = current_time where w.uuid = ?1")
    @Modifying
    public void updateAckTime(String var1);

    @Query(value="select distinct g from WorkerNode w join w.groups g where g in ?1")
    public List<String> findGroups(List<String> var1);

    @Modifying
    @Query(value="update WorkerNode w set w.uuid = w.uuid where w.uuid = ?1")
    public void lockByUuid(String var1);
}

