/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.engine.node.services;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.cloudslang.engine.node.entities.WorkerKeepAliveInfo;
import io.cloudslang.engine.node.entities.WorkerNode;
import io.cloudslang.engine.node.repositories.WorkerNodeRepository;
import io.cloudslang.engine.node.services.LoginListener;
import io.cloudslang.engine.node.services.WorkerLockService;
import io.cloudslang.engine.node.services.WorkerNodeService;
import io.cloudslang.engine.versioning.services.VersionService;
import io.cloudslang.score.api.nodes.WorkerStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class WorkerNodeServiceImpl
implements WorkerNodeService {
    private static final Logger logger = Logger.getLogger(WorkerNodeServiceImpl.class);
    private static final long MAX_VERSION_GAP_ALLOWED = Long.getLong("max.allowed.version.gap.worker.recovery", 2L);
    private static final String MSG_RECOVERY_VERSION_NAME = "MSG_RECOVERY_VERSION";
    @Autowired
    private WorkerNodeRepository workerNodeRepository;
    @Autowired
    private WorkerLockService workerLockService;
    @Autowired
    private VersionService versionService;
    @Autowired(required=false)
    private List<LoginListener> loginListeners;

    @Transactional
    public String keepAlive(String uuid) {
        WorkerNode worker = this.readByUUID(uuid);
        worker.setAckTime(new Date());
        String wrv = worker.getWorkerRecoveryVersion();
        long version = this.versionService.getCurrentVersion(MSG_RECOVERY_VERSION_NAME);
        worker.setAckVersion(version);
        if (!worker.getStatus().equals((Object)WorkerStatus.IN_RECOVERY)) {
            worker.setStatus(WorkerStatus.RUNNING);
        }
        logger.debug((Object)("Got keepAlive for Worker with uuid=" + uuid + " and update its ackVersion to " + version));
        return wrv;
    }

    @Transactional
    public WorkerKeepAliveInfo newKeepAlive(String uuid) {
        WorkerNode worker = this.readByUUID(uuid);
        worker.setAckTime(new Date());
        long version = this.versionService.getCurrentVersion(MSG_RECOVERY_VERSION_NAME);
        worker.setAckVersion(version);
        if (!worker.getStatus().equals((Object)WorkerStatus.IN_RECOVERY)) {
            worker.setStatus(WorkerStatus.RUNNING);
        }
        boolean active = worker.isActive();
        logger.debug((Object)("Got keepAlive for Worker with uuid=" + uuid + " and update its ackVersion to " + version + " isActive" + active));
        return new WorkerKeepAliveInfo(worker.getWorkerRecoveryVersion(), active);
    }

    @Transactional
    public void create(String uuid, String password, String hostName, String installDir) {
        WorkerNode worker = new WorkerNode();
        worker.setUuid(uuid);
        worker.setDescription(uuid);
        worker.setHostName(hostName);
        worker.setActive(false);
        worker.setInstallPath(installDir);
        worker.setStatus(WorkerStatus.FAILED);
        worker.setPassword(password);
        worker.setGroups(Arrays.asList(WorkerNode.DEFAULT_WORKER_GROUPS));
        this.workerNodeRepository.save(worker);
        this.workerLockService.create(uuid);
    }

    @Transactional
    public void updateWorkerToDeleted(String uuid) {
        WorkerNode worker = this.readByUUID(uuid);
        if (worker != null) {
            worker.setActive(false);
            worker.setDeleted(true);
            worker.setStatus(WorkerStatus.IN_RECOVERY);
        }
    }

    @Transactional
    public void updateWorkerToNotDeleted(String uuid) {
        WorkerNode worker = this.workerNodeRepository.findByUuidAndDeleted(uuid, true);
        if (worker != null) {
            worker.setActive(false);
            worker.setDeleted(false);
            worker.setStatus(WorkerStatus.IN_RECOVERY);
        }
    }

    @Transactional
    public List<WorkerNode> readAllNotDeletedWorkers() {
        return this.workerNodeRepository.findByDeletedOrderByIdAsc(false);
    }

    @Transactional
    public String up(String uuid, String version, String versionId) {
        if (this.loginListeners != null) {
            for (LoginListener listener : this.loginListeners) {
                listener.preLogin(uuid);
            }
        }
        WorkerKeepAliveInfo workerKeepAliveInfo = this.newKeepAlive(uuid);
        if (this.loginListeners != null) {
            for (LoginListener listener : this.loginListeners) {
                listener.postLogin(uuid);
            }
        }
        this.updateVersion(uuid, version, versionId);
        return workerKeepAliveInfo.getWorkerRecoveryVersion();
    }

    @Transactional
    @Deprecated
    public String up(String uuid) {
        if (this.loginListeners != null) {
            for (LoginListener listener : this.loginListeners) {
                listener.preLogin(uuid);
            }
        }
        WorkerKeepAliveInfo workerKeepAliveInfo = this.newKeepAlive(uuid);
        if (this.loginListeners != null) {
            for (LoginListener listener : this.loginListeners) {
                listener.postLogin(uuid);
            }
        }
        return workerKeepAliveInfo.getWorkerRecoveryVersion();
    }

    @Transactional(readOnly=true)
    public WorkerNode readByUUID(String uuid) {
        WorkerNode worker = this.workerNodeRepository.findByUuidAndDeleted(uuid, false);
        if (worker == null) {
            throw new IllegalStateException("no worker was found by the specified UUID:" + uuid);
        }
        return worker;
    }

    @Transactional(readOnly=true)
    public boolean isActive(String uuid) {
        WorkerNode worker = this.workerNodeRepository.findByUuidAndDeleted(uuid, false);
        if (worker == null) {
            throw new IllegalStateException("no worker was found by the specified UUID:" + uuid);
        }
        return worker.isActive();
    }

    @Transactional(readOnly=true)
    public WorkerNode findByUuid(String uuid) {
        WorkerNode worker = this.workerNodeRepository.findByUuid(uuid);
        if (worker == null) {
            throw new IllegalStateException("no worker was found by the specified UUID:" + uuid);
        }
        return worker;
    }

    @Transactional(readOnly=true)
    public List<WorkerNode> readAllWorkers() {
        return this.workerNodeRepository.findAll();
    }

    @Transactional(readOnly=true)
    public List<String> readAllWorkersUuids() {
        List workers = this.workerNodeRepository.findAll();
        ArrayList<String> result = new ArrayList<String>();
        for (WorkerNode w : workers) {
            result.add(w.getUuid());
        }
        return result;
    }

    @Transactional
    public void updateVersion(String workerUuid, String version, String versionId) {
        WorkerNode worker = this.workerNodeRepository.findByUuid(workerUuid);
        if (worker == null) {
            throw new IllegalStateException("No worker was found by the specified UUID:" + workerUuid);
        }
        worker.setVersion(version);
        worker.setVersionId(versionId);
    }

    @Transactional(readOnly=true)
    public List<String> readNonRespondingWorkers() {
        long systemVersion = this.versionService.getCurrentVersion(MSG_RECOVERY_VERSION_NAME);
        long minVersionAllowed = Math.max(systemVersion - MAX_VERSION_GAP_ALLOWED, 0L);
        return this.workerNodeRepository.findNonRespondingWorkers(minVersionAllowed, WorkerStatus.RECOVERED);
    }

    @Transactional(readOnly=true)
    public List<WorkerNode> readWorkersByActivation(boolean isActive) {
        return this.workerNodeRepository.findByActiveAndDeleted(isActive, false);
    }

    @Transactional
    public void activate(String uuid) {
        WorkerNode worker = this.readByUUID(uuid);
        worker.setActive(true);
    }

    @Transactional
    public void deactivate(String uuid) {
        WorkerNode worker = this.readByUUID(uuid);
        worker.setActive(false);
    }

    @Transactional
    public void updateEnvironmentParams(String uuid, String os, String jvm, String dotNetVersion) {
        WorkerNode worker = this.readByUUID(uuid);
        worker.setOs(os);
        worker.setJvm(jvm);
        worker.setDotNetVersion(dotNetVersion);
    }

    @Transactional
    public void updateStatus(String uuid, WorkerStatus status) {
        WorkerNode worker = this.workerNodeRepository.findByUuid(uuid);
        if (worker == null) {
            throw new IllegalStateException("no worker was found by the specified UUID:" + uuid);
        }
        worker.setStatus(status);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void updateStatusInSeparateTransaction(String uuid, WorkerStatus status) {
        WorkerNode worker = this.workerNodeRepository.findByUuid(uuid);
        if (worker == null) {
            throw new IllegalStateException("no worker was found by the specified UUID:" + uuid);
        }
        worker.setStatus(status);
    }

    @Transactional(readOnly=true)
    public List<String> readAllWorkerGroups() {
        return this.workerNodeRepository.findGroups();
    }

    @Transactional(readOnly=true)
    public List<String> readWorkerGroups(String uuid) {
        WorkerNode node = this.readByUUID(uuid);
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(node.getGroups());
        return res;
    }

    @Transactional
    public void updateWorkerGroups(String uuid, String ... groupNames) {
        WorkerNode worker = this.readByUUID(uuid);
        HashSet<String> groupSet = groupNames != null ? new HashSet<String>(Arrays.asList(groupNames)) : new HashSet();
        ArrayList<String> groups = new ArrayList<String>();
        groupSet.remove(null);
        groups.addAll(groupSet);
        worker.setGroups(groups);
    }

    @Transactional(readOnly=true)
    public Multimap<String, String> readGroupWorkersMapActiveAndRunningAndVersion(String versionId) {
        ArrayListMultimap result = ArrayListMultimap.create();
        List<WorkerNode> workers = this.workerNodeRepository.findByActiveAndStatusAndDeletedAndVersionId(true, WorkerStatus.RUNNING, false, versionId);
        for (WorkerNode worker : workers) {
            for (String groupName : worker.getGroups()) {
                result.put((Object)groupName, (Object)worker.getUuid());
            }
        }
        return result;
    }

    @Transactional
    public void addGroupToWorker(String workerUuid, String group) {
        if (group == null) {
            return;
        }
        WorkerNode worker = this.readByUUID(workerUuid);
        if (!worker.getGroups().contains(group)) {
            ArrayList<String> groups = new ArrayList<String>(worker.getGroups());
            groups.add(group);
            worker.setGroups(groups);
        }
    }

    @Transactional
    public void removeGroupFromWorker(String workerUuid, String group) {
        WorkerNode worker = this.readByUUID(workerUuid);
        ArrayList groups = new ArrayList(worker.getGroups());
        groups.remove(group);
        if (groups.size() == 0) {
            throw new IllegalStateException("Can't leave worker without any group !");
        }
        worker.setGroups(groups);
    }

    @Transactional(readOnly=true)
    public List<String> readWorkerGroups(List<String> groups) {
        return this.workerNodeRepository.findGroups(groups);
    }

    @Transactional
    public void updateBulkNumber(String workerUuid, String bulkNumber) {
        WorkerNode worker = this.readByUUID(workerUuid);
        worker.setBulkNumber(bulkNumber);
    }

    @Transactional
    public void updateWRV(String workerUuid, String wrv) {
        WorkerNode worker = this.workerNodeRepository.findByUuid(workerUuid);
        worker.setWorkerRecoveryVersion(wrv);
    }
}

