/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.engine.node.services;

import io.cloudslang.engine.node.entities.WorkerLock;
import io.cloudslang.engine.node.repositories.WorkerLockRepository;
import io.cloudslang.engine.node.services.WorkerLockService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public final class WorkerLockServiceImpl
implements WorkerLockService {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private WorkerLockRepository workerLockRepository;

    @Transactional
    public void create(String uuid) {
        WorkerLock workerLock = new WorkerLock();
        workerLock.setUuid(uuid);
        this.workerLockRepository.save(workerLock);
    }

    @Transactional
    public void delete(String uuid) {
        this.workerLockRepository.deleteByUuid(uuid);
    }

    @Transactional
    public void lock(String uuid) {
        if (this.workerLockRepository.lock(uuid) == 1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Worker [" + uuid + "] is locked");
            }
        } else {
            throw new IllegalStateException("Unknown worker uuid [" + uuid + "]");
        }
    }
}

