/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.engine.node.services;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import io.cloudslang.engine.node.entities.QueueDetails;
import io.cloudslang.engine.node.entities.WorkerKeepAliveInfo;
import io.cloudslang.engine.node.entities.WorkerNode;
import io.cloudslang.engine.node.repositories.WorkerNodeRepository;
import io.cloudslang.engine.node.services.LoginListener;
import io.cloudslang.engine.node.services.QueueConfigurationDataService;
import io.cloudslang.engine.node.services.WorkerLockService;
import io.cloudslang.engine.node.services.WorkerNodeService;
import io.cloudslang.engine.versioning.services.VersionService;
import io.cloudslang.score.api.nodes.WorkerStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

public class WorkerNodeServiceImpl
implements WorkerNodeService {
    private static final Logger logger = LogManager.getLogger(WorkerNodeServiceImpl.class);
    private static final long MAX_VERSION_GAP_ALLOWED = Long.getLong("max.allowed.version.gap.worker.recovery", 2L);
    private static boolean disableMonitoring = Boolean.getBoolean("global.worker.monitoring.disable");
    private static final String MSG_RECOVERY_VERSION_NAME = "MSG_RECOVERY_VERSION";
    @Autowired
    private WorkerNodeRepository workerNodeRepository;
    @Autowired
    private WorkerLockService workerLockService;
    @Autowired
    private VersionService versionService;
    @Autowired(required=false)
    private List<LoginListener> loginListeners;
    @Autowired
    private QueueConfigurationDataService queueConfigurationDataService;
    @Autowired
    private PlatformTransactionManager transactionManager;

    @PostConstruct
    void setWorkerMonitoring() {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        if (disableMonitoring) {
            logger.info("Monitoring is disabled,setting busyness status as not available for all workers");
            transactionTemplate.executeWithoutResult(transactionStatus -> this.readAllWorkersUuids().stream().forEach(uuid -> this.updateWorkerBusynessValue((String)uuid, "NA")));
        }
    }

    @Transactional
    public String keepAlive(String uuid) {
        WorkerNode worker = this.readByUUID(uuid);
        worker.setAckTime(new Date());
        String wrv = worker.getWorkerRecoveryVersion();
        long version = this.versionService.getCurrentVersion(MSG_RECOVERY_VERSION_NAME);
        worker.setAckVersion(version);
        if (!worker.getStatus().equals((Object)WorkerStatus.IN_RECOVERY)) {
            worker.setStatus(WorkerStatus.RUNNING);
        }
        logger.debug("Got keepAlive for Worker with uuid=" + uuid + " and update its ackVersion to " + version);
        return wrv;
    }

    @Transactional
    @Deprecated
    public WorkerKeepAliveInfo newKeepAlive(String uuid) {
        return this.newKeepAlive(uuid, true);
    }

    @Transactional
    public WorkerKeepAliveInfo newKeepAlive(String uuid, boolean versionMismatch) {
        WorkerNode worker = this.readByUUID(uuid);
        worker.setAckTime(new Date());
        long version = this.versionService.getCurrentVersion(MSG_RECOVERY_VERSION_NAME);
        worker.setAckVersion(version);
        if (!versionMismatch && !worker.getStatus().equals((Object)WorkerStatus.IN_RECOVERY)) {
            worker.setStatus(WorkerStatus.RUNNING);
        }
        boolean active = worker.isActive();
        logger.debug("Got keepAlive for Worker with uuid=" + uuid + " and update its ackVersion to " + version + " isActive" + active);
        QueueDetails queueDetails = this.queueConfigurationDataService.getQueueConfigurations();
        return new WorkerKeepAliveInfo(worker.getWorkerRecoveryVersion(), active, queueDetails, disableMonitoring);
    }

    @Transactional
    public void create(String uuid, String password, String hostName, String installDir) {
        WorkerNode worker = new WorkerNode();
        worker.setUuid(uuid);
        worker.setDescription(uuid);
        worker.setHostName(hostName);
        worker.setActive(false);
        worker.setInstallPath(installDir);
        worker.setStatus(WorkerStatus.FAILED);
        worker.setPassword(password);
        worker.setGroups(Arrays.asList(WorkerNode.DEFAULT_WORKER_GROUPS));
        worker.setWorkerBusynessValue("NA");
        this.workerNodeRepository.save(worker);
        this.workerLockService.create(uuid);
    }

    @Transactional
    public void updateWorkerToDeleted(String uuid) {
        WorkerNode worker = this.readByUUID(uuid);
        if (worker != null) {
            worker.setActive(false);
            worker.setDeleted(true);
            worker.setStatus(WorkerStatus.IN_RECOVERY);
        }
    }

    @Transactional
    public void updateWorkerToNotDeleted(String uuid) {
        WorkerNode worker = this.workerNodeRepository.findByUuidAndDeleted(uuid, true);
        if (worker != null) {
            worker.setActive(false);
            worker.setDeleted(false);
            worker.setStatus(WorkerStatus.IN_RECOVERY);
        }
    }

    @Transactional
    public List<WorkerNode> readAllNotDeletedWorkers() {
        return this.workerNodeRepository.findByDeletedOrderByIdAsc(false);
    }

    @Transactional
    public String up(String uuid, String version, String versionId, boolean versionMismatch) {
        if (this.loginListeners != null) {
            for (LoginListener listener : this.loginListeners) {
                listener.preLogin(uuid);
            }
        }
        WorkerKeepAliveInfo workerKeepAliveInfo = this.newKeepAlive(uuid, versionMismatch);
        if (this.loginListeners != null) {
            for (LoginListener listener : this.loginListeners) {
                listener.postLogin(uuid);
            }
        }
        this.updateVersion(uuid, version, versionId);
        return workerKeepAliveInfo.getWorkerRecoveryVersion();
    }

    @Transactional
    @Deprecated
    public String up(String uuid, String version, String versionId) {
        if (this.loginListeners != null) {
            for (LoginListener listener : this.loginListeners) {
                listener.preLogin(uuid);
            }
        }
        WorkerKeepAliveInfo workerKeepAliveInfo = this.newKeepAlive(uuid);
        if (this.loginListeners != null) {
            for (LoginListener listener : this.loginListeners) {
                listener.postLogin(uuid);
            }
        }
        this.updateVersion(uuid, version, versionId);
        return workerKeepAliveInfo.getWorkerRecoveryVersion();
    }

    @Transactional
    @Deprecated
    public String up(String uuid) {
        if (this.loginListeners != null) {
            for (LoginListener listener : this.loginListeners) {
                listener.preLogin(uuid);
            }
        }
        WorkerKeepAliveInfo workerKeepAliveInfo = this.newKeepAlive(uuid);
        if (this.loginListeners != null) {
            for (LoginListener listener : this.loginListeners) {
                listener.postLogin(uuid);
            }
        }
        return workerKeepAliveInfo.getWorkerRecoveryVersion();
    }

    @Transactional(readOnly=true)
    public WorkerNode readByUUID(String uuid) {
        WorkerNode worker = this.workerNodeRepository.findByUuidAndDeleted(uuid, false);
        if (worker == null) {
            throw new IllegalStateException("no worker was found by the specified UUID:" + uuid);
        }
        return worker;
    }

    @Transactional(readOnly=true)
    public boolean isActive(String uuid) {
        WorkerNode worker = this.workerNodeRepository.findByUuidAndDeleted(uuid, false);
        if (worker == null) {
            throw new IllegalStateException("no worker was found by the specified UUID:" + uuid);
        }
        return worker.isActive();
    }

    @Transactional(readOnly=true)
    public WorkerNode findByUuid(String uuid) {
        WorkerNode worker = this.workerNodeRepository.findByUuid(uuid);
        if (worker == null) {
            throw new IllegalStateException("no worker was found by the specified UUID:" + uuid);
        }
        return worker;
    }

    @Transactional(readOnly=true)
    public List<WorkerNode> readAllWorkers() {
        return this.workerNodeRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Map<String, Set<String>> readWorkerGroupsMap() {
        List all = this.workerNodeRepository.findAll();
        HashMap workerGroupsMap = Maps.newHashMapWithExpectedSize((int)all.size());
        for (WorkerNode workerNode : all) {
            workerGroupsMap.put(workerNode.getUuid(), new HashSet(workerNode.getGroups()));
        }
        return workerGroupsMap;
    }

    @Transactional(readOnly=true)
    public List<String> readAllWorkersUuids() {
        List workers = this.workerNodeRepository.findAll();
        ArrayList<String> result = new ArrayList<String>();
        for (WorkerNode w : workers) {
            result.add(w.getUuid());
        }
        return result;
    }

    @Transactional
    public void updateVersion(String workerUuid, String version, String versionId) {
        WorkerNode worker = this.workerNodeRepository.findByUuid(workerUuid);
        if (worker == null) {
            throw new IllegalStateException("No worker was found by the specified UUID:" + workerUuid);
        }
        worker.setVersion(version);
        worker.setVersionId(versionId);
    }

    @Transactional
    public void updateMigratedPassword(String workerUuid, String encodedPassword) {
        WorkerNode worker = this.workerNodeRepository.findByUuid(workerUuid);
        if (worker == null) {
            throw new IllegalStateException("No worker was found by the specified UUID:" + workerUuid);
        }
        if (StringUtils.isEmpty((String)encodedPassword)) {
            throw new IllegalStateException("Invalid encoded password provided for UUID:" + workerUuid);
        }
        if (!StringUtils.equals((String)worker.getMigratedPassword(), (String)encodedPassword)) {
            worker.setMigratedPassword(encodedPassword);
        }
    }

    @Transactional
    public void updateQueueSyncByUuid(String workerUuid, boolean isQueueSync) {
        WorkerNode worker = this.workerNodeRepository.findByUuid(workerUuid);
        if (worker == null) {
            throw new IllegalStateException("No worker was found by the specified UUID:" + workerUuid);
        }
        worker.setQueueSync(isQueueSync);
    }

    @Transactional
    public void updateQueueSync(boolean isQueueSync) {
        List workers = this.workerNodeRepository.findAll();
        for (WorkerNode w : workers) {
            w.setQueueSync(isQueueSync);
        }
    }

    @Transactional(readOnly=true)
    public List<String> readNonRespondingWorkers() {
        long systemVersion = this.versionService.getCurrentVersion(MSG_RECOVERY_VERSION_NAME);
        long minVersionAllowed = Math.max(systemVersion - MAX_VERSION_GAP_ALLOWED, 0L);
        return this.workerNodeRepository.findNonRespondingWorkers(minVersionAllowed, WorkerStatus.RECOVERED);
    }

    @Transactional(readOnly=true)
    public List<WorkerNode> readWorkersByActivation(boolean isActive) {
        return this.workerNodeRepository.findByActiveAndDeleted(isActive, false);
    }

    @Transactional
    public void activate(String uuid) {
        WorkerNode worker = this.readByUUID(uuid);
        worker.setActive(true);
    }

    @Transactional
    public void deactivate(String uuid) {
        WorkerNode worker = this.readByUUID(uuid);
        worker.setActive(false);
    }

    @Transactional
    public void updateEnvironmentParams(String uuid, String os, String jvm, String dotNetVersion) {
        WorkerNode worker = this.readByUUID(uuid);
        worker.setOs(os);
        worker.setJvm(jvm);
        worker.setDotNetVersion(dotNetVersion);
    }

    @Transactional
    public void updateStatus(String uuid, WorkerStatus status) {
        WorkerNode worker = this.workerNodeRepository.findByUuid(uuid);
        if (worker == null) {
            throw new IllegalStateException("no worker was found by the specified UUID:" + uuid);
        }
        worker.setStatus(status);
    }

    @Transactional
    public void updateWorkerBusynessValue(String uuid, String workerBusynessValue) {
        WorkerNode worker = this.workerNodeRepository.findByUuid(uuid);
        if (worker == null) {
            throw new IllegalStateException("no worker was found by the specified UUID:" + uuid);
        }
        worker.setWorkerBusynessValue(workerBusynessValue);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void updateStatusInSeparateTransaction(String uuid, WorkerStatus status) {
        WorkerNode worker = this.workerNodeRepository.findByUuid(uuid);
        if (worker == null) {
            throw new IllegalStateException("no worker was found by the specified UUID:" + uuid);
        }
        worker.setStatus(status);
    }

    @Transactional
    public void migratePassword(String uuid, String password) {
        WorkerNode workerNode = this.workerNodeRepository.findByUuid(uuid);
        if (workerNode == null) {
            throw new IllegalStateException("no worker was found by the specified UUID:" + uuid);
        }
        if (StringUtils.isNotEmpty((String)workerNode.getMigratedPassword())) {
            throw new IllegalStateException("the migration password has already been changed for the specified UUID:" + uuid);
        }
        workerNode.setMigratedPassword(password);
    }

    @Transactional(readOnly=true)
    public List<String> readAllWorkerGroups() {
        return this.workerNodeRepository.findGroups();
    }

    @Transactional(readOnly=true)
    public List<String> readWorkerGroups(String uuid) {
        WorkerNode node = this.readByUUID(uuid);
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(node.getGroups());
        return res;
    }

    @Transactional
    public void updateWorkerGroups(String uuid, String ... groupNames) {
        WorkerNode worker = this.readByUUID(uuid);
        HashSet<String> groupSet = groupNames != null ? new HashSet<String>(Arrays.asList(groupNames)) : new HashSet();
        ArrayList<String> groups = new ArrayList<String>();
        groupSet.remove(null);
        groups.addAll(groupSet);
        worker.setGroups(groups);
    }

    @Transactional(readOnly=true)
    public Multimap<String, String> readGroupWorkersMapActiveAndRunningAndVersion(String versionId) {
        ArrayListMultimap result = ArrayListMultimap.create();
        List<WorkerNode> workers = this.workerNodeRepository.findByActiveAndStatusAndDeletedAndVersionId(true, WorkerStatus.RUNNING, false, versionId);
        for (WorkerNode worker : workers) {
            for (String groupName : worker.getGroups()) {
                result.put((Object)groupName, (Object)worker.getUuid());
            }
        }
        return result;
    }

    @Transactional
    public void addGroupToWorker(String workerUuid, String group) {
        if (group == null) {
            return;
        }
        WorkerNode worker = this.readByUUID(workerUuid);
        if (!worker.getGroups().contains(group)) {
            ArrayList<String> groups = new ArrayList<String>(worker.getGroups());
            groups.add(group);
            worker.setGroups(groups);
        }
    }

    @Transactional
    public void removeGroupFromWorker(String workerUuid, String group) {
        WorkerNode worker = this.readByUUID(workerUuid);
        ArrayList groups = new ArrayList(worker.getGroups());
        groups.remove(group);
        if (groups.size() == 0) {
            throw new IllegalStateException("Can't leave worker without any group !");
        }
        worker.setGroups(groups);
    }

    @Transactional(readOnly=true)
    public List<String> readWorkerGroups(List<String> groups) {
        return this.workerNodeRepository.findGroups(groups);
    }

    @Transactional
    public void updateBulkNumber(String workerUuid, String bulkNumber) {
        WorkerNode worker = this.readByUUID(workerUuid);
        worker.setBulkNumber(bulkNumber);
    }

    @Transactional
    public void updateWRV(String workerUuid, String wrv) {
        WorkerNode worker = this.workerNodeRepository.findByUuid(workerUuid);
        worker.setWorkerRecoveryVersion(wrv);
    }
}

