/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.engine.node.services;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.cloudslang.engine.node.services.WorkerNodeService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Worker Nodes Managing API")
public class WorkersMBean {
    @Autowired
    private WorkerNodeService workerNodeService;
    private ObjectMapper mapper;

    private ObjectMapper objectMapper() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
            this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        return this.mapper;
    }

    @ManagedAttribute(description="Number of active workers")
    public int getActiveWorkers() {
        return this.workerNodeService.readWorkersByActivation(true).size();
    }

    @ManagedAttribute(description="Number of all registered workers")
    public int getTotalWorkers() {
        return this.workerNodeService.readAllWorkers().size();
    }

    @ManagedOperation(description="Returns a list of all registered workers")
    public String showWorkers() throws IOException {
        ObjectWriter objectWriter = this.objectMapper().writerWithDefaultPrettyPrinter();
        return objectWriter.writeValueAsString((Object)this.workerNodeService.readAllWorkers());
    }
}

