/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.accurest.stubrunner.spring.cloud;

import io.codearte.accurest.stubrunner.RunningStubs;
import io.codearte.accurest.stubrunner.StubFinder;
import io.codearte.accurest.stubrunner.spring.cloud.StubMapperProperties;
import io.codearte.accurest.stubrunner.spring.cloud.StubRunnerServiceInstance;
import io.codearte.accurest.stubrunner.util.StringUtils;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.noop.NoopDiscoveryClient;

public class StubRunnerDiscoveryClient
implements DiscoveryClient {
    private final DiscoveryClient delegate;
    private final StubFinder stubFinder;
    private final StubMapperProperties stubMapperProperties;

    public StubRunnerDiscoveryClient(DiscoveryClient delegate, StubFinder stubFinder, StubMapperProperties stubMapperProperties, String springAppName) {
        this.delegate = delegate instanceof StubRunnerDiscoveryClient ? this.noOpDiscoveryClient(springAppName) : delegate;
        this.stubFinder = stubFinder;
        this.stubMapperProperties = stubMapperProperties;
    }

    private NoopDiscoveryClient noOpDiscoveryClient(String springAppName) {
        return new NoopDiscoveryClient((ServiceInstance)new DefaultServiceInstance(springAppName, "localhost", 0, false));
    }

    public String description() {
        return this.delegate.description();
    }

    public ServiceInstance getLocalServiceInstance() {
        return this.delegate.getLocalServiceInstance();
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        String ivyNotation = this.stubMapperProperties.fromServiceIdToIvyNotation(serviceId);
        String serviceToFind = StringUtils.hasText((String)ivyNotation) ? ivyNotation : serviceId;
        URL stubUrl = this.stubFinder.findStubUrl(serviceToFind);
        if (stubUrl == null) {
            return this.delegate.getInstances(serviceId);
        }
        return Collections.singletonList(new StubRunnerServiceInstance(serviceId, stubUrl.getHost(), stubUrl.getPort(), this.toUri(stubUrl)));
    }

    private URI toUri(URL url) {
        try {
            return url.toURI();
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<String> getServices() {
        List services = this.delegate.getServices();
        RunningStubs runningStubs = this.stubFinder.findAllRunningStubs();
        services.addAll(runningStubs.getAllServicesNames());
        return services;
    }
}

