/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.accurest.stubrunner.spring.cloud;

import io.codearte.accurest.stubrunner.StubFinder;
import io.codearte.accurest.stubrunner.spring.StubRunnerConfiguration;
import io.codearte.accurest.stubrunner.spring.cloud.StubMapperProperties;
import io.codearte.accurest.stubrunner.spring.cloud.StubRunnerDiscoveryClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(value={DiscoveryClient.class})
@Import(value={StubRunnerConfiguration.class})
@ConditionalOnProperty(value={"stubrunner.cloud.enabled"}, matchIfMissing=true)
public class StubRunnerSpringCloudAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public StubMapperProperties stubMapperProperties() {
        return new StubMapperProperties();
    }

    @Bean
    @Primary
    public DiscoveryClient stubRunnerDiscoveryClient(DiscoveryClient discoveryClient, StubFinder stubFinder, StubMapperProperties stubMapperProperties, @Value(value="${spring.application.name:unknown}") String springAppName) {
        return new StubRunnerDiscoveryClient(discoveryClient, stubFinder, stubMapperProperties, springAppName);
    }
}

