/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.accurest.stubrunner.spring.cloud.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ServerList;
import io.codearte.accurest.stubrunner.StubFinder;
import io.codearte.accurest.stubrunner.spring.cloud.StubMapperProperties;
import io.codearte.accurest.stubrunner.spring.cloud.ribbon.StubRunnerRibbonServerList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;

class StubRunnerRibbonBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;
    private StubFinder stubFinder;
    private StubMapperProperties stubMapperProperties;
    private IClientConfig clientConfig;

    StubRunnerRibbonBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    private StubFinder stubFinder() {
        if (this.stubFinder == null) {
            this.stubFinder = (StubFinder)this.beanFactory.getBean(StubFinder.class);
        }
        return this.stubFinder;
    }

    private StubMapperProperties stubMapperProperties() {
        if (this.stubMapperProperties == null) {
            this.stubMapperProperties = (StubMapperProperties)this.beanFactory.getBean(StubMapperProperties.class);
        }
        return this.stubMapperProperties;
    }

    private IClientConfig clientConfig() {
        if (this.clientConfig == null) {
            this.clientConfig = (IClientConfig)this.beanFactory.getBean(IClientConfig.class);
        }
        return this.clientConfig;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ServerList && !(bean instanceof StubRunnerRibbonServerList)) {
            return new StubRunnerRibbonServerList(this.stubFinder(), this.stubMapperProperties(), this.clientConfig(), (ServerList)bean);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

